/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.version;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.jboss.pnc.api.constants.versions.VersionDistanceRule;
import org.jboss.pnc.common.version.SuffixedVersion;
import org.jboss.pnc.common.version.VersionParser;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private final VersionDistanceRule distanceRule;
    private final SuffixedVersion base;
    private final VersionParser versionParser;

    public VersionComparator(VersionParser versionParser) {
        this.base = null;
        this.distanceRule = null;
        this.versionParser = Objects.requireNonNull(versionParser);
    }

    public VersionComparator(String base, VersionParser versionParser) {
        this(base, VersionDistanceRule.RECOMMENDED_REPLACEMENT, versionParser);
    }

    public VersionComparator(String base, VersionDistanceRule distanceRule, VersionParser versionParser) {
        this.versionParser = Objects.requireNonNull(versionParser);
        this.base = versionParser.parse(Objects.requireNonNull(base));
        this.distanceRule = Objects.requireNonNull(distanceRule);
    }

    public VersionDifference difference(String version1, String version2) {
        SuffixedVersion v1 = this.versionParser.parse(version1);
        SuffixedVersion v2 = this.versionParser.parse(version2);
        return this.difference(v1, v2);
    }

    public VersionDifference difference(SuffixedVersion v1, SuffixedVersion v2) {
        if (v1.getMajor() != v2.getMajor()) {
            return VersionDifference.MAJOR;
        }
        if (v1.getMinor() != v2.getMinor()) {
            return VersionDifference.MINOR;
        }
        if (v1.getMicro() != v2.getMicro()) {
            return VersionDifference.MICRO;
        }
        if (!v1.getQualifier().equals(v2.getQualifier())) {
            return VersionDifference.QUALIFIER;
        }
        if (!v1.getSuffix().equals(v2.getSuffix())) {
            return VersionDifference.SUFFIX;
        }
        if (!v1.getSuffixVersion().equals(v2.getSuffixVersion())) {
            return VersionDifference.RH_SUFFIX;
        }
        return VersionDifference.EQUAL;
    }

    public VersionDifference difference(SuffixedVersion version) {
        return this.difference(this.base, version);
    }

    @Override
    public int compare(String version1, String version2) {
        SuffixedVersion v2;
        SuffixedVersion v1 = this.versionParser.parse(version1);
        int r = v1.compareTo(v2 = this.versionParser.parse(version2));
        if (r == 0 || this.base == null) {
            return r;
        }
        switch (this.distanceRule) {
            case RECOMMENDED_REPLACEMENT: {
                return this.compareAsRecommendedReplacement(v1, v2);
            }
            case CLOSEST_BY_PARTS: {
                return this.compareAsClosestByParts(v1, v2);
            }
        }
        throw new UnsupportedOperationException("Unknown distance rule " + this.distanceRule);
    }

    private int compareAsRecommendedReplacement(SuffixedVersion v1, SuffixedVersion v2) {
        if (this.base.equals(v1)) {
            return -1;
        }
        if (this.base.equals(v2)) {
            return 1;
        }
        if (v1.getMajor() != v2.getMajor()) {
            if (v1.getMajor() == this.base.getMajor()) {
                return -1;
            }
            if (v2.getMajor() == this.base.getMajor()) {
                return 1;
            }
        }
        Object[] versions = new SuffixedVersion[]{this.base, v1, v2};
        Arrays.sort(versions);
        if (versions[0] == this.base) {
            int candidate = versions[1] == v1 ? -1 : 1;
            if (v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro()) {
                candidate *= -1;
            }
            return candidate;
        }
        if (versions[2] == this.base) {
            if (versions[1] == v1) {
                return -1;
            }
            return 1;
        }
        if (versions[2] == v1) {
            return -1;
        }
        return 1;
    }

    private int compareAsClosestByParts(SuffixedVersion v1, SuffixedVersion v2) {
        VersionDifference differenceV2ToBase;
        if (this.base.equals(v1)) {
            return -1;
        }
        if (this.base.equals(v2)) {
            return 1;
        }
        VersionDifference difference = this.difference(v1, v2);
        VersionDifference differenceV1ToBase = this.difference(this.base, v1);
        if (differenceV1ToBase != (differenceV2ToBase = this.difference(this.base, v2))) {
            switch (difference) {
                case MAJOR: {
                    return differenceV1ToBase == VersionDifference.MAJOR ? 1 : -1;
                }
                case MINOR: {
                    return differenceV1ToBase == VersionDifference.MINOR ? 1 : -1;
                }
                case MICRO: {
                    return differenceV1ToBase == VersionDifference.MICRO ? 1 : -1;
                }
                case QUALIFIER: {
                    return differenceV1ToBase == VersionDifference.QUALIFIER ? 1 : -1;
                }
                case SUFFIX: {
                    return differenceV1ToBase == VersionDifference.SUFFIX ? 1 : -1;
                }
                case RH_SUFFIX: {
                    return differenceV1ToBase == VersionDifference.RH_SUFFIX ? 1 : -1;
                }
            }
            throw new IllegalStateException("Unknown difference " + difference);
        }
        if (differenceV1ToBase == differenceV2ToBase && differenceV1ToBase == difference) {
            switch (difference) {
                case MAJOR: {
                    return this.comparePart(this.base.getMajor(), v1.getMajor(), v2.getMajor());
                }
                case MINOR: {
                    return this.comparePart(this.base.getMinor(), v1.getMinor(), v2.getMinor());
                }
                case MICRO: {
                    return this.comparePart(this.base.getMicro(), v1.getMicro(), v2.getMicro());
                }
            }
        }
        Object[] versions = new SuffixedVersion[]{this.base, v1, v2};
        Arrays.sort(versions);
        if (versions[0] == this.base) {
            int candidate = versions[1] == v1 ? -1 : 1;
            if (difference != VersionDifference.MAJOR && difference != VersionDifference.MINOR && difference != VersionDifference.MICRO) {
                candidate *= -1;
            }
            return candidate;
        }
        if (versions[2] == this.base) {
            if (versions[1] == v1) {
                return -1;
            }
            return 1;
        }
        if (difference == VersionDifference.MAJOR || difference == VersionDifference.MINOR || difference == VersionDifference.MICRO) {
            throw new IllegalStateException("Broken rule 2");
        }
        if (versions[2] == v1) {
            return -1;
        }
        return 1;
    }

    private int comparePart(int base, int v1, int v2) {
        int v2diff;
        int v1diff = Math.abs(base - v1);
        if (v1diff == (v2diff = Math.abs(base - v2))) {
            if (v1 > v2) {
                return -1;
            }
            return 1;
        }
        return v1diff - v2diff;
    }

    public static enum VersionDifference {
        MAJOR,
        MINOR,
        MICRO,
        QUALIFIER,
        SUFFIX,
        RH_SUFFIX,
        EQUAL;

    }
}

