/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jboss.pnc.api.dependencyanalyzer.dto.QualifiedVersion;
import org.jboss.pnc.common.alignment.ranking.compiler.Compiler;
import org.jboss.pnc.common.alignment.ranking.compiler.RankCompiler;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.parser.DefaultParser;
import org.jboss.pnc.common.alignment.ranking.parser.InternalNode;
import org.jboss.pnc.common.alignment.ranking.parser.Parser;
import org.jboss.pnc.common.alignment.ranking.tokenizer.GenericTokenizer;
import org.jboss.pnc.common.alignment.ranking.tokenizer.OrderToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public class AlignmentRanking
implements Comparator<QualifiedVersion> {
    private static final EnumSet<TokenType> ALLOWED_TOKENS = EnumSet.of(TokenType.QVALUE, new TokenType[]{TokenType.ORDER, TokenType.LOGIC, TokenType.LPAREN, TokenType.RPAREN, TokenType.SORT_BY});
    public static final Set<Character> BLACKLISTED_CHARS = Set.of(Character.valueOf(';'));
    private final Parser parser = new DefaultParser();
    private Compiler<Comparator<QualifiedVersion>> compiler;
    private final List<RankHolder> ranks;

    public AlignmentRanking(List<String> alignmentRanks, Comparator<String> versionStringComparator) throws ValidationException {
        this.compiler = new RankCompiler(versionStringComparator);
        this.ranks = this.compile(alignmentRanks == null ? List.of() : alignmentRanks);
    }

    private List<RankHolder> compile(List<String> alignmentRanks) throws ValidationException {
        ArrayList<RankHolder> rankHolders = new ArrayList<RankHolder>();
        boolean foundDefault = false;
        for (int idx = 0; idx < alignmentRanks.size(); ++idx) {
            String rank = alignmentRanks.get(idx);
            GenericTokenizer tokenizer = new GenericTokenizer(rank, ALLOWED_TOKENS, BLACKLISTED_CHARS);
            ArrayList<Token> tokens = new ArrayList<Token>();
            while (tokenizer.hasNext()) {
                tokens.add(tokenizer.next());
            }
            if (tokens.size() == 1 && tokens.get(0) instanceof OrderToken) {
                foundDefault = true;
                if (idx != alignmentRanks.size() - 1) {
                    throw new ValidationException("SUFFIX-VERSION is not last rank.");
                }
            }
            InternalNode rootNode = this.parser.generateParseTree(tokens);
            Comparator<QualifiedVersion> comparator = this.compiler.compile(rootNode);
            rankHolders.add(new RankHolder(rank, tokens, rootNode, comparator));
        }
        if (!foundDefault) {
            rankHolders.addAll(this.compile(List.of("SUFFIX-VERSION")));
        }
        return rankHolders;
    }

    public List<List<Token>> getRanksAsTokens() {
        ArrayList<List<Token>> tokenizedRanks = new ArrayList<List<Token>>();
        this.ranks.forEach(rank -> tokenizedRanks.add(rank.tokens));
        return tokenizedRanks;
    }

    public boolean isDefault() {
        return this.ranks.size() == 1 && this.ranks.get((int)0).rank.equals("SUFFIX-VERSION");
    }

    public void overrideVersionComparator(Comparator<String> versionComparator) {
        this.compiler = new RankCompiler(versionComparator);
        this.recompile();
    }

    private void recompile() {
        for (int i = 0; i < this.ranks.size(); ++i) {
            RankHolder rank = this.ranks.get(i);
            this.ranks.set(i, new RankHolder(rank.rank, rank.tokens, rank.root, this.compiler.compile(rank.root)));
        }
    }

    @Override
    public int compare(QualifiedVersion ver1, QualifiedVersion ver2) {
        int result = 0;
        for (RankHolder rank : this.ranks) {
            result = rank.comparator.compare(ver1, ver2);
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    private static class RankHolder {
        private final String rank;
        private final List<Token> tokens;
        private final InternalNode root;
        private final Comparator<QualifiedVersion> comparator;

        @Generated
        public RankHolder(String rank, List<Token> tokens, InternalNode root, Comparator<QualifiedVersion> comparator) {
            this.rank = rank;
            this.tokens = tokens;
            this.root = root;
            this.comparator = comparator;
        }
    }
}

