/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.compiler;

import java.text.MessageFormat;
import org.jboss.pnc.api.dependencyanalyzer.dto.QualifiedVersion;
import org.jboss.pnc.common.alignment.ranking.compiler.Compiler;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.parser.BinaryNode;
import org.jboss.pnc.common.alignment.ranking.parser.InternalNode;
import org.jboss.pnc.common.alignment.ranking.parser.LeafNode;
import org.jboss.pnc.common.alignment.ranking.parser.Node;
import org.jboss.pnc.common.alignment.ranking.tokenizer.LogicToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.QualifierToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public abstract class AbstractCompiler<T>
implements Compiler<T> {
    protected abstract T handleBinaryNode(BinaryNode var1);

    protected abstract T handleLeafNode(LeafNode var1);

    @Override
    public T compile(InternalNode rootNode) {
        if (rootNode.childrenCount() != 1) {
            throw new ValidationException("Empty rank is not allowed.");
        }
        Node child = rootNode.getChildren().get(0);
        if (child instanceof BinaryNode) {
            BinaryNode bNode = (BinaryNode)child;
            return this.handleBinaryNode(bNode);
        }
        if (child instanceof LeafNode) {
            LeafNode lNode = (LeafNode)child;
            return this.handleLeafNode(lNode);
        }
        throw new IllegalArgumentException("Unknown Node Type: " + child.getClass().getCanonicalName());
    }

    protected boolean match(Node currentNode, QualifiedVersion version) {
        if (currentNode instanceof LeafNode) {
            LeafNode leaf = (LeafNode)currentNode;
            if (leaf.getToken().tokenType != TokenType.QVALUE) {
                throw new IllegalArgumentException("Unknown leaf token. Only Qualifier:Value pairs allowed.");
            }
            QualifierToken token = (QualifierToken)leaf.getToken();
            return version.has(token.qualifier, token.parts);
        }
        if (currentNode instanceof BinaryNode) {
            BinaryNode bNode = (BinaryNode)currentNode;
            switch (bNode.getToken().tokenType) {
                case LOGIC: {
                    LogicToken token = (LogicToken)bNode.getToken();
                    switch (token.logicType) {
                        case AND: {
                            return this.handleAnd(bNode, version);
                        }
                        case OR: {
                            return this.handleOr(bNode, version);
                        }
                    }
                    throw new IllegalArgumentException(MessageFormat.format("Unknown logic operation: {0}", new Object[]{token.logicType}));
                }
                case COMMA: {
                    return this.handleOr(bNode, version);
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("Unknown BinaryNode type {0}", bNode.getToken()));
        }
        return false;
    }

    private boolean handleAnd(BinaryNode currentNode, QualifiedVersion version) {
        boolean leftMatch = this.match(currentNode.getLeftChild(), version);
        if (!leftMatch) {
            return false;
        }
        boolean rightMatch = this.match(currentNode.getRightChild(), version);
        return leftMatch && rightMatch;
    }

    private boolean handleOr(BinaryNode currentNode, QualifiedVersion version) {
        boolean leftMatch = this.match(currentNode.getLeftChild(), version);
        if (leftMatch) {
            return true;
        }
        boolean rightMatch = this.match(currentNode.getRightChild(), version);
        return leftMatch || rightMatch;
    }
}

