/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.parser;

import java.text.MessageFormat;
import org.jboss.pnc.common.alignment.ranking.tokenizer.LogicToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public interface Priority {
    public int getPriority();

    default public int getPriority(Token token) {
        if (token.tokenType == TokenType.LOGIC) {
            LogicToken logicToken = (LogicToken)token;
            switch (logicToken.logicType) {
                case OR: {
                    return 1;
                }
                case AND: {
                    return 2;
                }
            }
        } else {
            if (token.tokenType == TokenType.COMMA) {
                return 1;
            }
            if (token.tokenType == TokenType.SORT_BY) {
                return 3;
            }
            if (token.tokenType == TokenType.LPAREN || token.tokenType == TokenType.RPAREN) {
                return 4;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Token {0} doesn't have a priority.", new Object[]{token.tokenType}));
    }
}

