/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.pnc.common.Numbers;
import org.jboss.pnc.common.concurrent.SequenceGenerator;

public class Sequence {
    private static final Map<Integer, Sequence> instance = new ConcurrentHashMap<Integer, Sequence>(1, 1.0f);
    private static final int INSTANCE_KEY = 0;
    private SequenceGenerator sequenceGenerator;

    public static void setNodeId(int nodeId) {
        Sequence.getInstance(nodeId);
    }

    public static String nextBase32Id() {
        return Numbers.decimalToBase32(Sequence.nextId());
    }

    public static Long nextId() {
        return Sequence.getInstance(null).sequenceGenerator.nextId();
    }

    private static Sequence getInstance(Integer nodeId) {
        return instance.computeIfAbsent(0, k -> new Sequence(nodeId));
    }

    private Sequence(Integer nodeId) {
        if (this.sequenceGenerator != null && nodeId != null) {
            throw new IllegalStateException("NodeId have to be called only once and before first call to nextId().");
        }
        this.sequenceGenerator = nodeId == null ? new SequenceGenerator() : new SequenceGenerator(nodeId);
    }
}

