/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.concurrent;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;

public class SequenceGenerator {
    private static final int UNUSED_BITS = 1;
    private static final int EPOCH_BITS = 41;
    private static final int NODE_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final int maxNodeId = (int)(Math.pow(2.0, 10.0) - 1.0);
    private static final int maxSequence = (int)(Math.pow(2.0, 12.0) - 1.0);
    private static final long CUSTOM_EPOCH = 1577836800000L;
    private final int nodeId;
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;

    SequenceGenerator(int nodeId) {
        if (nodeId < 0 || nodeId > maxNodeId) {
            throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, maxNodeId));
        }
        this.nodeId = nodeId;
    }

    SequenceGenerator() {
        this.nodeId = this.createNodeId();
    }

    public synchronized long nextId() {
        long currentTimestamp = SequenceGenerator.timestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new IllegalStateException("Invalid System Clock!");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (long)maxSequence;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitNextMillis(currentTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long id = currentTimestamp << 22;
        id |= (long)(this.nodeId << 12);
        return id |= this.sequence;
    }

    private static long timestamp() {
        return Instant.now().toEpochMilli() - 1577836800000L;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = SequenceGenerator.timestamp();
        }
        return currentTimestamp;
    }

    private int createNodeId() {
        int nodeId;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
            }
            nodeId = sb.toString().hashCode();
        }
        catch (Exception ex) {
            nodeId = new SecureRandom().nextInt();
        }
        return nodeId &= maxNodeId;
    }
}

