/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.concurrent.mdc;

import io.opentelemetry.context.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.pnc.common.concurrent.mdc.MDCThreadPoolExecutor;
import org.jboss.pnc.common.concurrent.mdc.MDCWrappers;

public class MDCScheduledThreadPoolExecutor
extends MDCThreadPoolExecutor
implements ScheduledExecutorService {
    ScheduledExecutorService scheduledExecutor;

    public MDCScheduledThreadPoolExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        this.executorService = Context.taskWrapping((ExecutorService)scheduledExecutor);
    }

    public MDCScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.executorService = Context.taskWrapping((ExecutorService)this.scheduledExecutor);
    }

    public MDCScheduledThreadPoolExecutor(int corePoolSize) {
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(corePoolSize);
        this.executorService = Context.taskWrapping((ExecutorService)this.scheduledExecutor);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(MDCWrappers.wrap(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(MDCWrappers.wrap(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(MDCWrappers.wrap(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(MDCWrappers.wrap(command), initialDelay, delay, unit);
    }
}

