/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.common.Json;
import org.jboss.pnc.common.http.PNCHttpClientConfig;
import org.jboss.pnc.common.http.PNCHttpClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PNCHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PNCHttpClient.class);
    private final HttpClient client;
    private final ObjectMapper objectMapper;
    private final Duration requestTimeout;
    private final RetryPolicy<HttpResponse<String>> retryPolicy;
    private Supplier<String> tokenSupplier;
    private Predicate<Integer> abortRetriesOnStatus = _ignored -> false;

    public PNCHttpClient(PNCHttpClientConfig config) {
        this(Json.newObjectMapper(), config);
    }

    public PNCHttpClient(ObjectMapper objectMapper, PNCHttpClientConfig config) {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(config.connectTimeout()).followRedirects(HttpClient.Redirect.NORMAL);
        if (config.forceHTTP11()) {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        this.client = builder.build();
        this.objectMapper = objectMapper;
        this.requestTimeout = config.requestTimeout();
        PNCHttpClientConfig.RetryConfig retryConfig = config.retryConfig();
        this.retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().withBackoff(retryConfig.backoffInitialDelay(), retryConfig.backoffMaxDelay()).withMaxRetries(retryConfig.maxRetries()).abortOn(this::abortOn).withMaxDuration(retryConfig.maxDuration()).onSuccess(e -> log.debug("Request successfully sent, response: {}", (Object)((HttpResponse)e.getResult()).statusCode()))).onRetry(e -> log.debug("Retrying (attempt #{}), last exception was: {}", (Object)e.getAttemptCount(), (Object)e.getLastException().getMessage())).onFailure(e -> log.warn("Request couldn't be sent.", e.getException()))).build();
    }

    private boolean abortOn(Throwable throwable) {
        PNCHttpClientException exception;
        if (throwable instanceof PNCHttpClientException && (exception = (PNCHttpClientException)throwable).getStatus() != null) {
            return this.abortRetriesOnStatus.test(exception.getStatus());
        }
        return false;
    }

    public void trySendRequest(Request request) {
        this.trySendRequest(request, request.getAttachment());
    }

    public void trySendRequest(Request request, Object payload) {
        HttpRequest httpRequest = this.prepareHttpRequest(request, payload);
        this.doSendRequest(httpRequest);
    }

    public void sendRequest(Request request) {
        this.sendRequest(request, request.getAttachment());
    }

    public void sendRequest(Request request, Object payload) {
        HttpRequest httpRequest = this.prepareHttpRequest(request, payload);
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> this.doSendRequest(httpRequest));
    }

    private void doSendRequest(HttpRequest httpRequest) {
        log.debug("Sending the request {}", (Object)httpRequest);
        try {
            HttpResponse<Void> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.discarding());
            log.debug("Response status code is: {}", (Object)response.statusCode());
            if (response.statusCode() >= 300) {
                throw new PNCHttpClientException("Sending request to " + httpRequest.method() + " " + String.valueOf(httpRequest.uri()) + " failed with status: " + response.statusCode(), response.statusCode());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new PNCHttpClientException("Sending request to " + httpRequest.method() + " " + String.valueOf(httpRequest.uri()) + " failed with error: " + e.getMessage(), e);
        }
    }

    private HttpRequest prepareHttpRequest(Request request, Object payload) {
        log.debug("Performing HTTP request with these parameters: {}", (Object)request);
        HttpRequest.Builder builder = HttpRequest.newBuilder(request.getUri());
        builder.timeout(this.requestTimeout);
        switch (request.getMethod()) {
            case POST: 
            case PATCH: 
            case PUT: {
                this.setMethodWithBody(builder, request.getMethod(), payload);
                break;
            }
            case DELETE: 
            case GET: 
            case HEAD: 
            case OPTIONS: {
                builder.method(request.getMethod().name(), HttpRequest.BodyPublishers.noBody());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot send " + String.valueOf(request.getMethod()) + " request.");
            }
        }
        request.getHeaders().forEach(h -> builder.header(h.getName(), h.getValue()));
        if (this.tokenSupplier != null) {
            builder.setHeader("Authorization", "Bearer " + this.tokenSupplier.get());
        }
        return builder.build();
    }

    private void setMethodWithBody(HttpRequest.Builder builder, Request.Method method, Object payload) {
        HttpRequest.BodyPublisher bp;
        if (payload == null) {
            bp = HttpRequest.BodyPublishers.noBody();
        } else {
            try {
                bp = HttpRequest.BodyPublishers.ofString(this.objectMapper.writeValueAsString(payload));
                builder.header("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                throw new PNCHttpClientException("Failure to parse payload object to JSON", e);
            }
        }
        builder.method(method.name(), bp);
    }

    @Generated
    public void setTokenSupplier(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Generated
    public void setAbortRetriesOnStatus(Predicate<Integer> abortRetriesOnStatus) {
        this.abortRetriesOnStatus = abortRetriesOnStatus;
    }
}

