/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.log;

import io.opentelemetry.api.trace.SpanContext;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.pnc.api.constants.MDCHeaderKeys;
import org.jboss.pnc.common.Strings;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.otel.OtelUtils;
import org.slf4j.MDC;

public class MDCUtils {
    public static final Map<String, String> HEADER_KEY_MAPPING;

    public static void setMDCFromRequestContext(ContainerRequestContext requestContext) {
        MDCUtils.setMDCFromHeaders(arg_0 -> ((ContainerRequestContext)requestContext).getHeaderString(arg_0));
    }

    public static void setMDCFromHeaders(Function<String, String> headers) {
        HashMap<String, String> mdcContext = new HashMap<String, String>();
        for (MDCHeaderKeys key : MDCHeaderKeys.values()) {
            MDCUtils.copyFromHeaders(mdcContext, key, headers);
        }
        MDCUtils.copyFromHeaders(mdcContext, MDCHeaderKeys.REQUEST_CONTEXT, headers, () -> Sequence.nextId().toString());
        MDC.setContextMap(mdcContext);
    }

    public static void addMDCFromOtelHeadersWithFallback(ContainerRequestContext requestContext, MDCHeaderKeys traceKey, MDCHeaderKeys spanKey, MDCHeaderKeys traceFlagsKey, MDCHeaderKeys traceStateKey, SpanContext fallbackSpanContext) {
        SpanContext extractedSpanContext = OtelUtils.extractSpanContextFromHeaders(requestContext);
        if (fallbackSpanContext == null) {
            fallbackSpanContext = SpanContext.getInvalid();
        }
        if (extractedSpanContext != null && extractedSpanContext.isValid()) {
            MDC.put((String)traceKey.getMdcKey(), (String)extractedSpanContext.getTraceId());
            MDC.put((String)spanKey.getMdcKey(), (String)extractedSpanContext.getSpanId());
            MDC.put((String)traceFlagsKey.getMdcKey(), (String)extractedSpanContext.getTraceFlags().asHex());
            MDC.put((String)traceStateKey.getMdcKey(), (String)extractedSpanContext.getTraceState().asMap().entrySet().stream().map(Objects::toString).collect(Collectors.joining(",")));
        } else {
            MDC.put((String)traceKey.getMdcKey(), (String)fallbackSpanContext.getTraceId());
            MDC.put((String)spanKey.getMdcKey(), (String)fallbackSpanContext.getSpanId());
            MDC.put((String)traceFlagsKey.getMdcKey(), (String)fallbackSpanContext.getTraceFlags().asHex());
            MDC.put((String)traceStateKey.getMdcKey(), (String)fallbackSpanContext.getTraceState().asMap().entrySet().stream().map(Objects::toString).collect(Collectors.joining(",")));
        }
    }

    public static void addMDCFromOtelHeadersWithFallback(ContainerRequestContext requestContext, SpanContext fallbackSpanContext, boolean slf4jStandard) {
        String mdcTraceKey = slf4jStandard ? "trace_id" : "traceId";
        String mdcSpanKey = slf4jStandard ? "span_id" : "spanId";
        String mdcTraceFlagsKey = slf4jStandard ? "trace_flags" : "traceFlags";
        String mdcTraceStateKey = slf4jStandard ? "trace_state" : "traceState";
        SpanContext extractedSpanContext = OtelUtils.extractSpanContextFromHeaders(requestContext);
        if (fallbackSpanContext == null) {
            fallbackSpanContext = SpanContext.getInvalid();
        }
        if (extractedSpanContext != null && extractedSpanContext.isValid()) {
            MDC.put((String)mdcTraceKey, (String)extractedSpanContext.getTraceId());
            MDC.put((String)mdcSpanKey, (String)extractedSpanContext.getSpanId());
            MDC.put((String)mdcTraceFlagsKey, (String)extractedSpanContext.getTraceFlags().asHex());
            MDC.put((String)mdcTraceStateKey, (String)extractedSpanContext.getTraceState().asMap().entrySet().stream().map(Objects::toString).collect(Collectors.joining(",")));
        } else {
            MDC.put((String)mdcTraceKey, (String)fallbackSpanContext.getTraceId());
            MDC.put((String)mdcSpanKey, (String)fallbackSpanContext.getSpanId());
            MDC.put((String)mdcTraceFlagsKey, (String)fallbackSpanContext.getTraceFlags().asHex());
            MDC.put((String)mdcTraceStateKey, (String)fallbackSpanContext.getTraceState().asMap().entrySet().stream().map(Objects::toString).collect(Collectors.joining(",")));
        }
    }

    public static Map<String, String> getHeadersFromMDC() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (MDCHeaderKeys key : MDCHeaderKeys.values()) {
            String value = MDC.get((String)key.getMdcKey());
            if (Strings.isEmpty(value)) continue;
            headers.put(key.getHeaderName(), value);
        }
        headers.putAll(MDCUtils.getOtelHeadersFromMDC());
        return headers;
    }

    public static Map<String, String> getOtelHeadersFromMDC() {
        String traceId = Strings.isEmpty(MDC.get((String)"trace_id")) ? MDC.get((String)"traceId") : MDC.get((String)"trace_id");
        String spanId = Strings.isEmpty(MDC.get((String)"span_id")) ? MDC.get((String)"spanId") : MDC.get((String)"span_id");
        String traceFlags = Strings.isEmpty(MDC.get((String)"trace_flags")) ? MDC.get((String)"traceFlags") : MDC.get((String)"trace_flags");
        String traceState = Strings.isEmpty(MDC.get((String)"trace_state")) ? MDC.get((String)"traceState") : MDC.get((String)"trace_state");
        HashMap<String, String> otelHeaders = new HashMap<String, String>();
        otelHeaders.putAll(OtelUtils.createTraceParentHeader(traceId, spanId, traceFlags));
        otelHeaders.putAll(OtelUtils.createTraceStateHeader(traceState));
        return otelHeaders;
    }

    private static void copyFromHeaders(Map<String, String> map, MDCHeaderKeys headerKeys, Function<String, String> valueGetter) {
        String value = valueGetter.apply(headerKeys.getHeaderName());
        if (!Strings.isEmpty(value)) {
            map.put(headerKeys.getMdcKey(), value);
        }
    }

    private static void copyFromHeaders(Map<String, String> map, MDCHeaderKeys headerKeys, Function<String, String> valueGetter, Supplier<String> defaultSupplier) {
        String value = valueGetter.apply(headerKeys.getHeaderName());
        if (Strings.isEmpty(value)) {
            map.put(headerKeys.getMdcKey(), defaultSupplier.get());
        } else {
            map.put(headerKeys.getMdcKey(), value);
        }
    }

    static {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (MDCHeaderKeys headerKey : MDCHeaderKeys.values()) {
            mapping.put(headerKey.getMdcKey(), headerKey.getHeaderName());
        }
        HEADER_KEY_MAPPING = Collections.unmodifiableMap(mapping);
    }
}

