/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ProcessStageUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"org.jboss.pnc._userlog_.process-stage-update");
    public static final String MDC_PROCESS_STAGE_NAME = "process_stage_name";
    public static final String MDC_PROCESS_STAGE_STEP = "process_stage_step";

    private static void logProcessStage(String processStage, Step step, String message) {
        try (MDC.MDCCloseable a = MDC.putCloseable((String)MDC_PROCESS_STAGE_NAME, (String)processStage);
             MDC.MDCCloseable b = MDC.putCloseable((String)MDC_PROCESS_STAGE_STEP, (String)step.toString());){
            log.info("{}", (Object)message);
        }
    }

    public static void logProcessStageBegin(String processStage) {
        ProcessStageUtils.logProcessStage(processStage, Step.BEGIN, String.format("%s: %s ", Step.BEGIN.toString(), processStage));
    }

    public static void logProcessStageBegin(String processStage, String message) {
        ProcessStageUtils.logProcessStage(processStage, Step.BEGIN, message);
    }

    public static void logProcessStageEnd(String processStage) {
        ProcessStageUtils.logProcessStage(processStage, Step.END, String.format("%s: %s ", Step.END.toString(), processStage));
    }

    public static void logProcessStageEnd(String processStage, String message) {
        ProcessStageUtils.logProcessStage(processStage, Step.END, message);
    }

    public static void closeActiveStages(String message) {
    }

    public static AutoCloseable startCloseableStage(String processStage) {
        ProcessStageUtils.logProcessStageBegin(processStage);
        return () -> ProcessStageUtils.logProcessStageEnd(processStage);
    }

    public static enum Step {
        BEGIN,
        END;

    }
}

