/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.tokenizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.pnc.api.enums.Qualifier;
import org.jboss.pnc.common.alignment.ranking.Logic;
import org.jboss.pnc.common.alignment.ranking.Order;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenKind;

public enum TokenType {
    QVALUE(Qualifier.class),
    ORDER(Order.class),
    LOGIC(Logic.class),
    LPAREN('('),
    RPAREN(')'),
    COMMA(','),
    SORT_BY("SORT_BY");

    public final TokenKind kind;
    private final Class<? extends Enum<?>> declaringEnum;
    public final char charLiteral;
    public final String literal;

    public List<String> getEnumValues() {
        if (this.declaringEnum != null) {
            return Arrays.stream(this.declaringEnum.getEnumConstants()).map(Enum::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private TokenType(String literal) {
        this.kind = TokenKind.LITERAL;
        this.literal = literal;
        this.declaringEnum = null;
        this.charLiteral = '\u0000';
    }

    private TokenType(char character) {
        this.kind = TokenKind.CHAR;
        this.literal = null;
        this.declaringEnum = null;
        this.charLiteral = character;
    }

    private TokenType(Class<? extends Enum<?>> enumeration) {
        this.kind = TokenKind.ENUM;
        this.literal = null;
        this.declaringEnum = enumeration;
        this.charLiteral = '\u0000';
    }
}

