/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.jboss.pnc.api.dto.HeartbeatConfig;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.common.http.PNCHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeartbeatScheduler.class);
    private final Map<String, ScheduledFuture<?>> subscribedRequests = new ConcurrentHashMap();
    private final ScheduledExecutorService executor;
    private final PNCHttpClient httpClient;

    public HeartbeatScheduler(ScheduledExecutorService executor, PNCHttpClient httpClient) {
        this.executor = executor;
        this.httpClient = httpClient;
    }

    public void subscribeRequest(String id, HeartbeatConfig heartbeatConfig) {
        ScheduledFuture<?> beat = this.executor.scheduleAtFixedRate(() -> this.sendHeartbeat(heartbeatConfig.getRequest()), 0L, heartbeatConfig.getDelay(), heartbeatConfig.getDelayTimeUnit());
        this.subscribedRequests.put(id, beat);
    }

    public void unsubscribeRequest(String id) {
        ScheduledFuture<?> toRemove = this.subscribedRequests.remove(id);
        if (toRemove != null) {
            toRemove.cancel(false);
        }
    }

    private void sendHeartbeat(Request heartbeatRequest) {
        try {
            this.httpClient.trySendRequest(heartbeatRequest);
        }
        catch (RuntimeException e) {
            log.warn("Heartbeat failed with an exception!", (Throwable)e);
        }
    }
}

