/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.concurrent.mdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.slf4j.MDC;

public class MDCWrappers {
    public static Runnable wrap(Runnable runnable) {
        Map context = MDC.getCopyOfContextMap();
        return () -> {
            Map previous = MDC.getCopyOfContextMap();
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                runnable.run();
            }
            finally {
                if (previous == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)previous);
                }
            }
        };
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        Map context = MDC.getCopyOfContextMap();
        return () -> {
            Map previous = MDC.getCopyOfContextMap();
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (previous == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)previous);
                }
            }
        };
    }

    public static <T> Consumer<T> wrap(Consumer<T> consumer) {
        Map context = MDC.getCopyOfContextMap();
        return t -> {
            Map previous = MDC.getCopyOfContextMap();
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                consumer.accept(t);
            }
            finally {
                if (previous == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)previous);
                }
            }
        };
    }

    public static <T> Collection<Callable<T>> wrapCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> wrapped = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            wrapped.add(MDCWrappers.wrap(task));
        }
        return wrapped;
    }
}

