/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);
    private static final String EMPTY_STRING = "";
    private static final String OSGI_VERSION_DELIMITER = ".";
    private static final String OSGI_QUALIFIER_DELIMITER = "-";
    private static final String DELIMITER_REGEX = "[.\\-_]";
    private static final String LEADING_DELIMITER_REGEX = "^[.\\-_]";
    private static final String MMM_REGEX = "(\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?";
    private static final Pattern mmmPattern = Pattern.compile("(\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?");
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private static final String QUALIFIER_REGEX = "(.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$";
    private static final String VERSION_REGEX = "((\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?)(([.\\-_])?((.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$))";
    private static final Pattern versionPattern = Pattern.compile("((\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?)(([.\\-_])?((.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$))");
    private static final String OSGI_VERSION_REGEX = "(\\d+)(\\.\\d+(\\.\\d+(\\.[\\w\\-_]+)?)?)?";
    private static final Pattern osgiPattern = Pattern.compile("(\\d+)(\\.\\d+(\\.\\d+(\\.[\\w\\-_]+)?)?)?");

    private Version() {
    }

    public static String getMMM(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(1);
        }
        return EMPTY_STRING;
    }

    static String getOsgiMMM(String version, boolean fill) {
        String mmm = Version.getMMM(version);
        Matcher mmmMatcher = mmmPattern.matcher(mmm);
        if (mmmMatcher.matches()) {
            Object osgiMMM = mmmMatcher.group(1);
            String minorVersion = mmmMatcher.group(3);
            if (!Version.isEmpty(minorVersion)) {
                osgiMMM = (String)osgiMMM + OSGI_VERSION_DELIMITER + minorVersion;
            } else if (fill) {
                osgiMMM = (String)osgiMMM + ".0";
            }
            String microVersion = mmmMatcher.group(5);
            if (!Version.isEmpty(microVersion)) {
                osgiMMM = (String)osgiMMM + OSGI_VERSION_DELIMITER + microVersion;
            } else if (fill) {
                osgiMMM = (String)osgiMMM + ".0";
            }
            return osgiMMM;
        }
        return EMPTY_STRING;
    }

    public static String getOsgiVersion(String version) {
        String mmm;
        Object qualifier = Version.getQualifier(version);
        if (!Version.isEmpty((String)qualifier)) {
            qualifier = OSGI_VERSION_DELIMITER + ((String)qualifier).replace(OSGI_VERSION_DELIMITER, OSGI_QUALIFIER_DELIMITER);
        }
        if (Version.isEmpty(mmm = Version.getOsgiMMM(version, !Version.isEmpty((String)qualifier)))) {
            logger.warn("Unable to parse version for OSGi: {}", (Object)version);
            return version;
        }
        return mmm + (String)qualifier;
    }

    public static String getQualifier(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(9);
        }
        return Version.removeLeadingDelimiter(version);
    }

    public static boolean isEmpty(String string) {
        return string == null || EMPTY_STRING.equals(string.trim());
    }

    public static boolean isValidOSGi(String version) {
        return osgiPattern.matcher(version).matches();
    }

    static String removeLeadingDelimiter(String versionPart) {
        return versionPart.replaceAll(LEADING_DELIMITER_REGEX, EMPTY_STRING);
    }
}

