/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.pnc.api.constants.versions.VersionDistanceRule;
import org.jboss.pnc.api.constants.versions.VersionFilter;
import org.jboss.pnc.api.dependencyanalyzer.dto.QualifiedVersion;
import org.jboss.pnc.common.alignment.ranking.VersionStrategy;
import org.jboss.pnc.common.version.SuffixedVersion;
import org.jboss.pnc.common.version.VersionComparator;
import org.jboss.pnc.common.version.VersionParser;

public class VersionAnalyzer {
    public static final Map<VersionFilter, EnumSet<VersionComparator.VersionDifference>> ALLOWED_DIFFERENCE = new HashMap<VersionFilter, EnumSet<VersionComparator.VersionDifference>>();
    private static final Pattern VERSION_PATTERN;
    private final VersionParser versionParser;
    private final List<String> suffixes = new ArrayList<String>();
    private final VersionDistanceRule distanceRule;
    private final VersionStrategy strategies;

    public VersionAnalyzer(List<String> suffixes) {
        this(suffixes, VersionDistanceRule.RECOMMENDED_REPLACEMENT);
    }

    public VersionAnalyzer(List<String> suffixes, VersionStrategy strategies) {
        this(suffixes, VersionDistanceRule.RECOMMENDED_REPLACEMENT, strategies);
    }

    public VersionAnalyzer(List<String> suffixes, VersionDistanceRule distanceRule) {
        this(suffixes, distanceRule, VersionStrategy.none());
    }

    public VersionAnalyzer(List<String> suffixes, VersionDistanceRule distanceRule, VersionStrategy strategies) {
        this.suffixes.addAll(suffixes);
        this.versionParser = new VersionParser(suffixes);
        this.distanceRule = Objects.requireNonNull(distanceRule);
        this.strategies = Objects.requireNonNull(strategies);
        strategies.getRanks().overrideVersionComparator(this::compareByBuildNumber);
    }

    public List<String> sortVersions(String querry, Collection<String> versions) {
        VersionComparator comparator = new VersionComparator(querry, this.distanceRule, this.versionParser);
        List<String> sortedVersions = versions.stream().sorted(comparator).distinct().collect(Collectors.toList());
        return sortedVersions;
    }

    public List<String> filterVersions(String query, VersionFilter vf, Collection<String> versions) {
        VersionComparator vc = new VersionComparator(query, this.distanceRule, this.versionParser);
        return versions.stream().map(this.versionParser::parseSuffixed).flatMap(Collection::stream).filter(v -> this.matches(vc, (SuffixedVersion)v, vf)).map(SuffixedVersion::getOriginalVersion).sorted(vc).distinct().collect(Collectors.toList());
    }

    private boolean matches(VersionComparator vc, SuffixedVersion v, VersionFilter vf) {
        VersionComparator.VersionDifference difference = vc.difference(v);
        return ALLOWED_DIFFERENCE.get(vf).contains((Object)difference);
    }

    public Optional<String> findBiggestMatchingVersion(String query, Collection<QualifiedVersion> versions) {
        String unsuffixedQuery = this.versionParser.parse(query).unsuffixedVersion();
        List candidateSuffixedVersions = versions.stream().map(this.versionParser::parseSuffixed).flatMap(Collection::stream).filter(sv -> this.strategies.getAllowList().test(sv.getOriginalVersionWithMeta())).filter(sv -> this.strategies.getDenyList().negate().test(sv.getOriginalVersionWithMeta())).filter(v -> unsuffixedQuery.equals(v.unsuffixedVersion())).collect(Collectors.toList());
        List versionsToSearch = Collections.emptyList();
        for (String suffix : this.suffixes) {
            versionsToSearch = candidateSuffixedVersions.stream().filter(v -> suffix.equals(v.getSuffix().get())).collect(Collectors.toList());
            if (versionsToSearch.isEmpty()) continue;
            break;
        }
        return versionsToSearch.stream().map(SuffixedVersion::getOriginalVersionWithMeta).max(this.strategies.getRanks()).map(QualifiedVersion::getVersion);
    }

    private int compareByBuildNumber(String first, String second) {
        int secondBuildNum;
        SuffixedVersion firstSuffixed = this.versionParser.parse(first);
        SuffixedVersion secondSuffixed = this.versionParser.parse(second);
        int firstBuildNum = firstSuffixed.getSuffixVersion().get();
        if (firstBuildNum > (secondBuildNum = secondSuffixed.getSuffixVersion().get().intValue())) {
            return 1;
        }
        if (firstBuildNum == secondBuildNum) {
            return VersionAnalyzer.getMoreSpecificVersion(first, second);
        }
        return -1;
    }

    private static int getMoreSpecificVersion(String first, String second) {
        boolean returnFirst;
        Matcher firstMatcher = VERSION_PATTERN.matcher(first);
        Matcher secondMatcher = VERSION_PATTERN.matcher(second);
        if (!firstMatcher.matches()) {
            throw new IllegalArgumentException("Couldn't parse version " + first);
        }
        if (!secondMatcher.matches()) {
            throw new IllegalArgumentException("Couldn't parse version " + second);
        }
        boolean firstIsOSGi = first.equals(VersionParser.getOSGiVersion(first));
        boolean secondIsOSGi = second.equals(VersionParser.getOSGiVersion(second));
        String firstMinor = firstMatcher.group("minor");
        String firstMicro = firstMatcher.group("micro");
        if (firstIsOSGi != secondIsOSGi) {
            returnFirst = firstIsOSGi;
        } else if (!Objects.equals(firstMinor, secondMatcher.group("minor"))) {
            returnFirst = firstMinor != null;
        } else if (!Objects.equals(firstMicro, secondMatcher.group("micro"))) {
            returnFirst = firstMicro != null;
        } else {
            boolean bl = returnFirst = firstMatcher.group("qualifier").startsWith(".") || !secondMatcher.group("qualifier").startsWith(".");
        }
        if (returnFirst) {
            return 1;
        }
        return -1;
    }

    static {
        ALLOWED_DIFFERENCE.put(VersionFilter.ALL, EnumSet.allOf(VersionComparator.VersionDifference.class));
        ALLOWED_DIFFERENCE.put(VersionFilter.MAJOR, EnumSet.of(VersionComparator.VersionDifference.MINOR, new VersionComparator.VersionDifference[]{VersionComparator.VersionDifference.MICRO, VersionComparator.VersionDifference.QUALIFIER, VersionComparator.VersionDifference.SUFFIX, VersionComparator.VersionDifference.RH_SUFFIX, VersionComparator.VersionDifference.EQUAL}));
        ALLOWED_DIFFERENCE.put(VersionFilter.MAJOR_MINOR, EnumSet.of(VersionComparator.VersionDifference.MICRO, VersionComparator.VersionDifference.QUALIFIER, VersionComparator.VersionDifference.SUFFIX, VersionComparator.VersionDifference.RH_SUFFIX, VersionComparator.VersionDifference.EQUAL));
        ALLOWED_DIFFERENCE.put(VersionFilter.MAJOR_MINOR_MICRO, EnumSet.of(VersionComparator.VersionDifference.QUALIFIER, VersionComparator.VersionDifference.SUFFIX, VersionComparator.VersionDifference.RH_SUFFIX, VersionComparator.VersionDifference.EQUAL));
        ALLOWED_DIFFERENCE.put(VersionFilter.MAJOR_MINOR_MICRO_QUALIFIER, EnumSet.of(VersionComparator.VersionDifference.SUFFIX, VersionComparator.VersionDifference.RH_SUFFIX, VersionComparator.VersionDifference.EQUAL));
        VERSION_PATTERN = Pattern.compile("^((?<major>[0-9]{1,9})?(\\.(?<minor>[0-9]{1,9})(\\.$|[.-](?<micro>[0-9]{1,9}))?)?)(?<qualifier>[.-]?(.+?))?");
    }
}

