/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.builddriver;

import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;

public class BuildDriverMock
implements BuildDriver {
    public static final Logger log = Logger.getLogger(BuildDriverMock.class);
    private BuildStatus buildStatus;

    public String getDriverId() {
        return "termd-build-driver";
    }

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, final RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) throws BuildDriverException {
        log.debug((Object)("Building " + buildExecutionSession.getId()));
        new Thread(() -> {
            try {
                this.complete(buildExecutionSession, runningEnvironment, onComplete);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }).start();
        return new RunningBuild(){

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }

            public void cancel() throws BuildDriverException {
            }
        };
    }

    private void complete(BuildExecutionSession buildExecutionSession, final RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete) throws InterruptedException {
        Thread.sleep(RandomUtils.randInt((int)100, (int)300));
        this.setBuildStatus(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript());
        onComplete.accept(new CompletedBuild(){

            public BuildDriverResult getBuildResult() throws BuildDriverException {
                return BuildDriverMock.this.getBuildResultMock(runningEnvironment);
            }

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }
        });
    }

    private void setBuildStatus(String buildScript) {
        this.buildStatus = buildScript.equals("mvn clean install -Dmock.config=Fail") ? BuildStatus.FAILED : BuildStatus.SUCCESS;
    }

    private BuildDriverResult getBuildResultMock(RunningEnvironment runningEnvironment) {
        return new BuildDriverResult(){

            public String getBuildLog() {
                return "Building in workspace ... Finished: SUCCESS";
            }

            public BuildStatus getBuildStatus() {
                return BuildDriverMock.this.buildStatus;
            }
        };
    }
}

