/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.jboss.pnc.common.util.NamedThreadFactory;
import org.jboss.pnc.mock.builddriver.BuildDriverResultMock;
import org.jboss.pnc.mock.executor.BuildExecutionSessionMock;
import org.jboss.pnc.mock.repositorymanager.RepositoryManagerResultMock;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.spi.BuildExecutionStatus;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.spi.executor.BuildExecutor;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
public class BuildExecutorMock
implements BuildExecutor {
    private final Logger log = LoggerFactory.getLogger(BuildExecutorMock.class);
    private final Map<Integer, BuildExecutionSession> runningExecutions = new HashMap<Integer, BuildExecutionSession>();
    private final ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("build-executor-mock"));

    public BuildExecutionSession startBuilding(BuildExecutionConfiguration buildExecutionConfiguration, Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent) throws ExecutorException {
        this.log.debug("Starting mock build execution for buildExecutionConfiguration.id {}", (Object)buildExecutionConfiguration.getId());
        BuildExecutionSessionMock buildExecutionSession = new BuildExecutionSessionMock(buildExecutionConfiguration, onBuildExecutionStatusChangedEvent);
        buildExecutionSession.setStatus(BuildExecutionStatus.NEW);
        this.runningExecutions.put(buildExecutionConfiguration.getId(), buildExecutionSession);
        Consumer<BuildExecutionStatus> onCompleteInternal = buildStatus -> {
            this.log.debug("Removing buildExecutionConfiguration.id [" + buildExecutionConfiguration.getId() + "] form list of running tasks.");
            this.runningExecutions.remove(buildExecutionConfiguration.getId());
            buildExecutionSession.setStatus((BuildExecutionStatus)buildStatus);
        };
        CompletableFuture.supplyAsync(() -> this.mockBuild(buildExecutionSession), this.executor).thenApplyAsync(buildPassed -> this.complete((Boolean)buildPassed, onCompleteInternal), (Executor)this.executor);
        return buildExecutionSession;
    }

    private Integer complete(Boolean buildPassed, Consumer<BuildExecutionStatus> onCompleteInternal) {
        if (buildPassed.booleanValue()) {
            onCompleteInternal.accept(BuildExecutionStatus.DONE);
        } else {
            onCompleteInternal.accept(BuildExecutionStatus.DONE_WITH_ERRORS);
        }
        return -1;
    }

    private Boolean mockBuild(BuildExecutionSession buildExecutionSession) {
        Boolean buildPassed;
        BuildDriverResult driverResult;
        this.log.debug("Building {}.", (Object)buildExecutionSession.getId());
        if ("mvn clean install -Dmock.config=Fail".equals(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript())) {
            this.log.debug("Marking build {} as Failed.", (Object)buildExecutionSession.getId());
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.FAILED);
            buildPassed = false;
        } else {
            this.log.debug("Marking build {} as Success.", (Object)buildExecutionSession.getId());
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.SUCCESS);
            RepositoryManagerResult repositoryManagerResult = RepositoryManagerResultMock.mockResult();
            buildExecutionSession.setRepositoryManagerResult(repositoryManagerResult);
            buildPassed = true;
        }
        buildExecutionSession.setBuildDriverResult(driverResult);
        return buildPassed;
    }

    public BuildExecutionSession getRunningExecution(int buildExecutionTaskId) {
        return this.runningExecutions.get(buildExecutionTaskId);
    }

    public void shutdown() {
    }
}

