/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.builddriver;

import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.pnc.mock.builddriver.BuildDriverBase;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;

public class BlockedBuildDriverMock
extends BuildDriverBase
implements BuildDriver {
    public static final Logger log = Logger.getLogger(BlockedBuildDriverMock.class);
    Semaphore semaphore = new Semaphore(0);

    @Override
    protected RunningBuild createRunningBuild(final RunningEnvironment runningEnvironment) {
        return new RunningBuild(){

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }

            public void cancel() {
                log.info((Object)"Cancelling blocked build...");
                BlockedBuildDriverMock.this.semaphore.release();
            }
        };
    }

    @Override
    protected void complete(BuildExecutionSession buildExecutionSession, final RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete) throws InterruptedException {
        log.info((Object)"Running blocked build ...");
        this.semaphore.acquire();
        this.setBuildStatus("mvn clean install -Dmock.config=Cancel");
        log.info((Object)"Blocked build canceled.");
        onComplete.accept(new CompletedBuild(){

            public BuildDriverResult getBuildResult() throws BuildDriverException {
                return BlockedBuildDriverMock.this.getBuildResultMock(runningEnvironment);
            }

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }
        });
    }

    public String getDriverId() {
        return "termd-build-driver";
    }
}

