/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.builddriver;

import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.mock.builddriver.BuildDriverBase;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;

public class BuildDriverMock
extends BuildDriverBase
implements BuildDriver {
    public static final Logger log = Logger.getLogger(BuildDriverMock.class);

    public String getDriverId() {
        return "termd-build-driver";
    }

    @Override
    protected RunningBuild createRunningBuild(final RunningEnvironment runningEnvironment) {
        return new RunningBuild(){

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }

            public void cancel() {
                throw new UnsupportedOperationException("Not implmented in mock driver");
            }
        };
    }

    @Override
    protected void complete(BuildExecutionSession buildExecutionSession, final RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete) throws InterruptedException {
        Thread.sleep(RandomUtils.randInt((int)100, (int)300));
        this.setBuildStatus(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript());
        onComplete.accept(new CompletedBuild(){

            public BuildDriverResult getBuildResult() throws BuildDriverException {
                return BuildDriverMock.this.getBuildResultMock(runningEnvironment);
            }

            public RunningEnvironment getRunningEnvironment() {
                return runningEnvironment;
            }
        });
    }
}

