/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.executor;

import java.net.URI;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.pnc.mock.executor.BuildExecutorStatusChangedEventMock;
import org.jboss.pnc.spi.BuildExecutionStatus;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildExecutionSessionMock
implements BuildExecutionSession {
    private static final Logger log = LoggerFactory.getLogger(BuildExecutionSessionMock.class);
    private final BuildExecutionConfiguration buildExecutionConfiguration;
    private final Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent;
    private BuildExecutionStatus status;
    private ExecutorException executorException;
    private Optional<URI> liveLogsUri = Optional.empty();
    private Date startTime;
    private RunningEnvironment runningEnvironment;
    private Date endTime;
    private BuildDriverResult buildDriverResult;
    private RepositoryManagerResult repositoryManagerResult;
    private BuildExecutionStatus failedReasonStatus;

    public BuildExecutionSessionMock(BuildExecutionConfiguration buildExecutionConfiguration, Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent) {
        this.buildExecutionConfiguration = buildExecutionConfiguration;
        this.onBuildExecutionStatusChangedEvent = onBuildExecutionStatusChangedEvent;
    }

    public Optional<URI> getLiveLogsUri() {
        return this.liveLogsUri;
    }

    public void setLiveLogsUri(Optional<URI> liveLogsUri) {
        this.liveLogsUri = liveLogsUri;
    }

    public void getEventLog() {
    }

    public BuildExecutionConfiguration getBuildExecutionConfiguration() {
        return this.buildExecutionConfiguration;
    }

    public BuildExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(BuildExecutionStatus status) {
        if (status.hasFailed() && this.failedReasonStatus == null) {
            log.debug("Setting status {} as failed reason for session {}.", (Object)status, (Object)this.getId());
            this.failedReasonStatus = status;
        }
        Optional<Object> buildResult = status.isCompleted() ? Optional.of(this.getBuildResult()) : Optional.empty();
        BuildExecutorStatusChangedEventMock statusChanged = new BuildExecutorStatusChangedEventMock(this.status, status, this.getId(), this.buildExecutionConfiguration.getId(), buildResult);
        log.debug("Updating build execution task {} status to {}.", (Object)this.getId(), (Object)statusChanged);
        this.status = status;
        this.onBuildExecutionStatusChangedEvent.accept(statusChanged);
        log.debug("Fired events after build execution task {} update.", (Object)this.getId());
    }

    private BuildResult getBuildResult() {
        if (this.executorException == null) {
            if (this.failedReasonStatus == null) {
                log.trace("Returning result of task {} with no exception.", (Object)this.getId());
                return new BuildResult(Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(this.repositoryManagerResult), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }
            log.trace("Returning result of task " + this.getId() + " with failed reason {}.", (Object)this.failedReasonStatus);
            return new BuildResult(Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(this.repositoryManagerResult), Optional.empty(), Optional.of(this.failedReasonStatus), Optional.empty(), Optional.empty(), Optional.empty());
        }
        log.trace("Returning result of task " + this.getId() + " with exception.", (Throwable)this.executorException);
        return new BuildResult(Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(this.repositoryManagerResult), Optional.of(this.executorException), Optional.ofNullable(this.failedReasonStatus), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ExecutorException getException() {
        return this.executorException;
    }

    public void setException(ExecutorException executorException) {
        log.debug("Setting exception: {}", (Object)(executorException != null ? executorException.getMessage() : "null"));
        this.executorException = executorException;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean hasFailed() {
        log.debug("Has failed ? executorException: {} || failedReasonStatus: {}", (Object)(this.executorException == null ? "" : this.executorException.getMessage()), (Object)this.failedReasonStatus);
        return this.executorException != null || this.failedReasonStatus != null;
    }

    public Integer getId() {
        return this.getBuildExecutionConfiguration().getId();
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public RunningEnvironment getRunningEnvironment() {
        return this.runningEnvironment;
    }

    public void setRunningEnvironment(RunningEnvironment runningEnvironment) {
        this.runningEnvironment = runningEnvironment;
    }

    public void setBuildDriverResult(BuildDriverResult buildDriverResult) {
        this.buildDriverResult = buildDriverResult;
    }

    public BuildDriverResult getBuildDriverResult() {
        return this.buildDriverResult;
    }

    public void setRepositoryManagerResult(RepositoryManagerResult repositoryManagerResult) {
        this.repositoryManagerResult = repositoryManagerResult;
    }
}

