/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.model.builders;

import javax.inject.Inject;
import org.jboss.pnc.mock.datastore.DatastoreMock;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.Project;

public class TestProjectConfigurationBuilder {
    public static final String FAIL = "mvn clean install -Dmock.config=Fail";
    public static final String FAIL_WITH_DELAY = "mvn clean install -Dmock.config=FailWithDelay";
    public static final String PASS = "mvn clean install -Dmock.config=Pass";
    public static final String CANCEL = "mvn clean install -Dmock.config=Cancel";
    BuildEnvironment javaBuildEnvironment = BuildEnvironment.Builder.newBuilder().build();
    @Inject
    DatastoreMock datastore;

    @Deprecated
    public TestProjectConfigurationBuilder() {
    }

    public TestProjectConfigurationBuilder(DatastoreMock datastore) {
        this.datastore = datastore;
    }

    public BuildConfiguration buildConfigurationWhichDependsOnItself() {
        BuildConfiguration buildConfiguration = this.build(1, "depends-on-itself");
        buildConfiguration.addDependency(buildConfiguration);
        return buildConfiguration;
    }

    public BuildConfiguration buildConfigurationWithCycleDependency(BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration1 = this.build(1, "cycle-dependency-1", buildConfigurationSet);
        BuildConfiguration buildConfiguration2 = this.build(2, "cycle-dependency-2", buildConfigurationSet);
        BuildConfiguration buildConfiguration3 = this.build(3, "cycle-dependency-3", buildConfigurationSet);
        buildConfiguration1.addDependency(buildConfiguration2);
        buildConfiguration2.addDependency(buildConfiguration3);
        buildConfiguration3.addDependency(buildConfiguration1);
        return buildConfiguration1;
    }

    public BuildConfiguration buildConfigurationWithDependencies(BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration1 = this.build(1, "with-dependencies-1", buildConfigurationSet);
        BuildConfiguration buildConfiguration2 = this.build(2, "with-dependencies-2", buildConfigurationSet);
        BuildConfiguration buildConfiguration3 = this.build(3, "with-dependencies-3", buildConfigurationSet);
        BuildConfiguration buildConfiguration4 = this.build(4, "with-dependencies-4", buildConfigurationSet);
        BuildConfiguration buildConfiguration5 = this.build(5, "with-dependencies-5", buildConfigurationSet);
        buildConfiguration1.addDependency(buildConfiguration2);
        buildConfiguration1.addDependency(buildConfiguration3);
        buildConfiguration2.addDependency(buildConfiguration3);
        buildConfiguration2.addDependency(buildConfiguration4);
        buildConfiguration3.addDependency(buildConfiguration5);
        buildConfiguration4.addDependency(buildConfiguration5);
        return buildConfiguration1;
    }

    public BuildConfiguration buildConfigurationWithDependenciesThatFail(BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration1 = this.build(1, "with-dependencies-1", buildConfigurationSet);
        BuildConfiguration buildConfiguration2 = this.buildFailingConfiguration(2, "with-dependencies-2", buildConfigurationSet);
        buildConfiguration1.addDependency(buildConfiguration2);
        return buildConfiguration1;
    }

    public BuildConfiguration buildConfigurationWithTransitiveDependenciesThatFail(BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration1 = this.build(1, "with-dependencies-1", buildConfigurationSet);
        BuildConfiguration buildConfiguration2 = this.build(2, "with-dependencies-2", buildConfigurationSet);
        BuildConfiguration buildConfiguration3 = this.buildFailingConfiguration(3, "with-dependencies-3", buildConfigurationSet);
        buildConfiguration1.addDependency(buildConfiguration2);
        buildConfiguration2.addDependency(buildConfiguration3);
        return buildConfiguration1;
    }

    public BuildConfiguration build(int id, String name) {
        return this.build(id, name, null);
    }

    public BuildConfiguration build(int id, String name, BuildConfigurationSet buildConfigurationSet) {
        Project project = new Project();
        project.setId(Integer.valueOf(id));
        project.setName(name);
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        buildConfiguration.setId(Integer.valueOf(id));
        buildConfiguration.setBuildScript(PASS);
        buildConfiguration.setName(id + "");
        buildConfiguration.setBuildEnvironment(this.javaBuildEnvironment);
        buildConfiguration.setProject(project);
        buildConfiguration.setArchived(false);
        project.addBuildConfiguration(buildConfiguration);
        if (buildConfigurationSet != null) {
            buildConfigurationSet.addBuildConfiguration(buildConfiguration);
        }
        this.datastore.save(buildConfiguration);
        return buildConfiguration;
    }

    public BuildConfiguration buildFailingConfiguration(int id, String name, BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration = this.build(id, name, buildConfigurationSet);
        buildConfiguration.setBuildScript(FAIL);
        return buildConfiguration;
    }

    public BuildConfiguration buildFailingWithDelayConfiguration(int id, String name, BuildConfigurationSet buildConfigurationSet) {
        BuildConfiguration buildConfiguration = this.build(id, name, buildConfigurationSet);
        buildConfiguration.setBuildScript(FAIL_WITH_DELAY);
        return buildConfiguration;
    }

    public BuildConfiguration buildConfigurationToCancel(int id, String name) {
        BuildConfiguration buildConfiguration = this.build(id, name);
        buildConfiguration.setBuildScript(CANCEL);
        return buildConfiguration;
    }

    public BuildConfigurationSet buildConfigurationSet(Integer configurationSetId) {
        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();
        buildConfigurationSet.setName("test-build-configuration");
        buildConfigurationSet.setId(configurationSetId);
        this.buildConfigurationWithDependencies(buildConfigurationSet);
        return buildConfigurationSet;
    }

    public BuildConfigurationSet buildConfigurationSetWithFailedDependencies(Integer configurationSetId) {
        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();
        buildConfigurationSet.setName("test-build-configuration-failed-deps");
        buildConfigurationSet.setId(configurationSetId);
        this.buildConfigurationWithDependenciesThatFail(buildConfigurationSet);
        return buildConfigurationSet;
    }

    public BuildConfigurationSet buildConfigurationSetWithFailedDependenciesAndDelay(Integer configurationSetId) {
        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();
        buildConfigurationSet.setName("test-build-configuration-failed-deps");
        buildConfigurationSet.setId(configurationSetId);
        this.buildConfigurationWithTransitiveDependenciesThatFail(buildConfigurationSet);
        return buildConfigurationSet;
    }

    public BuildConfigurationSet buildConfigurationSetWithCycleDependency() {
        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();
        buildConfigurationSet.setName("test-cycle");
        this.buildConfigurationWithCycleDependency(buildConfigurationSet);
        return buildConfigurationSet;
    }
}

