/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repositorymanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactRepo;
import org.jboss.pnc.spi.coordinator.CompletionStatus;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.jboss.pnc.spi.repositorymanager.model.RepositoryConnectionInfo;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;

public class RepositorySessionMock
implements RepositorySession {
    public ArtifactRepo.Type getType() {
        return ArtifactRepo.Type.MAVEN;
    }

    public String getBuildRepositoryId() {
        return "test";
    }

    public RepositoryConnectionInfo getConnectionInfo() {
        return new RepositoryConnectionInfo(){
            String repo = "http://localhost:8090/api/groups/test";

            public String getToolchainUrl() {
                return this.repo;
            }

            public Map<String, String> getProperties() {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("altDeploymentRepository", "test::default::" + this.repo);
                return props;
            }

            public String getDependencyUrl() {
                return this.repo;
            }

            public String getDeployUrl() {
                return this.repo;
            }
        };
    }

    public RepositoryManagerResult extractBuildArtifacts() throws RepositoryManagerException {
        return new RepositoryManagerResult(){

            public List<Artifact> getBuiltArtifacts() {
                ArrayList<Artifact> builtArtifacts = new ArrayList<Artifact>();
                builtArtifacts.add(RepositorySessionMock.this.getArtifact(1));
                return builtArtifacts;
            }

            public List<Artifact> getDependencies() {
                ArrayList<Artifact> dependencies = new ArrayList<Artifact>();
                dependencies.add(RepositorySessionMock.this.getArtifact(10));
                return dependencies;
            }

            public String getBuildContentId() {
                return "mock-content-id";
            }

            public String getLog() {
                return "";
            }

            public CompletionStatus getCompletionStatus() {
                return CompletionStatus.SUCCESS;
            }
        };
    }

    private Artifact getArtifact(int i) {
        return Artifact.Builder.newBuilder().id(Integer.valueOf(i)).identifier("org.jboss.pnc:mock.artifact" + i).build();
    }
}

