/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.environmentdriver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.EnvironmentDriver;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.environment.exception.EnvironmentDriverException;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;

@ApplicationScoped
public class EnvironmentDriverMock
implements EnvironmentDriver {
    public StartedEnvironment startEnvironment(String systemImageId, String systemImageRepositoryUrl, SystemImageType buildType, final RepositorySession repositoryConfiguration, DebugData debugData, String accessToken) throws EnvironmentDriverException {
        return new StartedEnvironment(){

            public void destroyEnvironment() throws EnvironmentDriverException {
            }

            public void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError) {
                onComplete.accept(new RunningEnvironment(){

                    public RepositorySession getRepositorySession() {
                        return repositoryConfiguration;
                    }

                    public Path getWorkingDirectory() {
                        try {
                            Path tempDirectory = Files.createTempDirectory("EnvironmentDriverMock", new FileAttribute[0]);
                            tempDirectory.toFile().deleteOnExit();
                            return tempDirectory;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public DebugData getDebugData() {
                        return new DebugData(false);
                    }

                    public String getBuildAgentUrl() {
                        return "http://10.10.10.10:8080";
                    }

                    public String getHost() {
                        return "10.10.10.10";
                    }

                    public String getInternalBuildAgentUrl() {
                        return this.getBuildAgentUrl();
                    }

                    public int getBuildAgentPort() {
                        return 0;
                    }

                    public String getId() {
                        return null;
                    }

                    public void destroyEnvironment() throws EnvironmentDriverException {
                    }
                });
            }

            public String getId() {
                return null;
            }

            public void cancel() {
            }
        };
    }

    public boolean canRunImageType(SystemImageType buildType) {
        return true;
    }
}

