/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.common.util.NamedThreadFactory;
import org.jboss.pnc.mock.builddriver.BuildDriverResultMock;
import org.jboss.pnc.mock.executor.BuildExecutionSessionMock;
import org.jboss.pnc.mock.repositorymanager.RepositoryManagerResultMock;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.spi.BuildExecutionStatus;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.spi.executor.BuildExecutor;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BuildExecutorMock
implements BuildExecutor {
    private final Logger log = LoggerFactory.getLogger(BuildExecutorMock.class);
    private final Map<Integer, BuildExecutionSession> runningExecutions = new HashMap<Integer, BuildExecutionSession>();
    private final ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("build-executor-mock"));

    public BuildExecutionSession startBuilding(BuildExecutionConfiguration buildExecutionConfiguration, Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent, String accessToken) throws ExecutorException {
        this.log.info("Starting mock build execution for buildExecutionConfiguration.id {}", (Object)buildExecutionConfiguration.getId());
        BuildExecutionSessionMock buildExecutionSession = new BuildExecutionSessionMock(buildExecutionConfiguration, onBuildExecutionStatusChangedEvent);
        buildExecutionSession.setStatus(BuildExecutionStatus.NEW);
        this.runningExecutions.put(buildExecutionConfiguration.getId(), buildExecutionSession);
        Consumer<BuildExecutionStatus> onCompleteInternal = buildStatus -> {
            this.log.debug("Removing buildExecutionConfiguration.id [" + buildExecutionConfiguration.getId() + "] form list of running tasks.");
            this.runningExecutions.remove(buildExecutionConfiguration.getId());
            buildExecutionSession.setStatus((BuildExecutionStatus)buildStatus);
        };
        CompletableFuture.supplyAsync(() -> this.mockBuild(buildExecutionSession), this.executor).handleAsync((buildPassed, e) -> this.complete((Boolean)buildPassed, (Throwable)e, onCompleteInternal), (Executor)this.executor);
        return buildExecutionSession;
    }

    private Integer complete(Boolean buildPassed, Throwable e, Consumer<BuildExecutionStatus> onCompleteInternal) {
        if (e != null) {
            this.log.error("Error in mock build.", e);
        }
        this.log.debug("Completing mock build.");
        if (buildPassed.booleanValue()) {
            onCompleteInternal.accept(BuildExecutionStatus.DONE);
        } else {
            onCompleteInternal.accept(BuildExecutionStatus.DONE_WITH_ERRORS);
        }
        return -1;
    }

    private Boolean mockBuild(BuildExecutionSession buildExecutionSession) {
        Boolean buildPassed;
        BuildDriverResult driverResult;
        this.log.debug("Building {}.", (Object)buildExecutionSession.getId());
        if ("mvn clean install -Dmock.config=Fail".equals(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript())) {
            this.log.debug("Marking build {} as Failed.", (Object)buildExecutionSession.getId());
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.FAILED);
            buildExecutionSession.setStatus(BuildExecutionStatus.BUILD_COMPLETED_WITH_ERROR);
            buildPassed = false;
        } else if ("mvn clean install -Dmock.config=FailWithDelay".equals(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript())) {
            this.log.debug("Waiting for a while for a build {}.", (Object)buildExecutionSession.getId());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.log.warn("Build mock has been interrupted.", (Throwable)e);
            }
            this.log.debug("Marking build {} as Failed.", (Object)buildExecutionSession.getId());
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.FAILED);
            buildPassed = false;
        } else if ("mvn clean install -Dmock.config=Cancel".equals(buildExecutionSession.getBuildExecutionConfiguration().getBuildScript())) {
            this.log.debug("Waiting for a while for a build {} to be canceled.", (Object)buildExecutionSession.getId());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.warn("Build mock has been interrupted.", (Throwable)e);
            }
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.SUCCESS);
            buildPassed = false;
        } else {
            this.log.debug("Marking build {} as Success.", (Object)buildExecutionSession.getId());
            driverResult = BuildDriverResultMock.mockResult(BuildStatus.SUCCESS);
            RepositoryManagerResult repositoryManagerResult = RepositoryManagerResultMock.mockResult();
            buildExecutionSession.setRepositoryManagerResult(repositoryManagerResult);
            buildPassed = true;
        }
        buildExecutionSession.setBuildDriverResult(driverResult);
        return buildPassed;
    }

    public BuildExecutionSession getRunningExecution(int buildExecutionTaskId) {
        return this.runningExecutions.get(buildExecutionTaskId);
    }

    public void shutdown() {
    }

    public void cancel(Integer executionConfigurationId) throws ExecutorException {
        BuildExecutionSession buildExecutionSession = this.runningExecutions.get(executionConfigurationId);
        if (buildExecutionSession == null) {
            this.log.error("Unable to cancel build {}. The build is not running.", (Object)executionConfigurationId);
            return;
        }
        this.log.info("Cancelling build {}.", (Object)executionConfigurationId);
        BuildDriverResult driverResult = BuildDriverResultMock.mockResult(BuildStatus.CANCELLED);
        buildExecutionSession.setBuildDriverResult(driverResult);
    }
}

