/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.model.builders;

import java.time.Instant;
import java.util.Date;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.TargetRepository;

public class ArtifactBuilder {
    public static final String IDENTIFIER_PREFIX = "org.jboss.pnc:mock.artifact";

    private static Artifact.Builder getArtifactBuilder(int id) {
        return Artifact.Builder.newBuilder().id(Integer.valueOf(id)).identifier("org.jboss.pnc:mock.artifact:" + id).md5("md-fake-ABCDABCD" + id).sha1("sha1-fake-ABCDABCD" + id).sha256("sha256-fake-ABCDABCD" + id).size(Long.valueOf(12342L)).deployPath("http://myrepo.com/org/jboss/mock/artifactFile" + id + ".jar").targetRepository(ArtifactBuilder.mockTargetRepository("")).filename("artifactFile" + id + ".jar");
    }

    public static Artifact mockArtifact(int id) {
        return ArtifactBuilder.getArtifactBuilder(id).build();
    }

    public static Artifact mockImportedArtifact(int id) {
        return ArtifactBuilder.getArtifactBuilder(id).importDate(Date.from(Instant.now())).originUrl("http://central.maven.org/org/jboss/mock/artifactFile" + id + ".jar").build();
    }

    public static TargetRepository mockTargetRepository(String path) {
        return TargetRepository.builder().identifier("indy-maven").repositoryPath(path).repositoryType(TargetRepository.Type.MAVEN).temporaryRepo(Boolean.valueOf(false)).build();
    }
}

