/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;

public class RepositoryMock<EntityType extends GenericEntity<Integer>>
implements Repository<EntityType, Integer> {
    private final AtomicInteger idSequence = new AtomicInteger(0);
    protected final List<EntityType> data = new ArrayList<EntityType>();

    public EntityType save(EntityType entity) {
        Integer id = (Integer)entity.getId();
        if (id == null) {
            entity.setId((Serializable)Integer.valueOf(this.idSequence.getAndIncrement()));
            id = (Integer)entity.getId();
        }
        this.getOptionalById(id).ifPresent(this.data::remove);
        this.data.add(entity);
        return entity;
    }

    public List<EntityType> queryAll() {
        return this.data;
    }

    public List<EntityType> queryAll(PageInfo pageInfo, SortInfo sortInfo) {
        return null;
    }

    public List<EntityType> queryWithPredicates(PageInfo pageInfo, SortInfo sortInfo, Predicate<EntityType> ... predicates) {
        return null;
    }

    public List<EntityType> queryWithPredicates(Predicate<EntityType> ... predicates) {
        return null;
    }

    public int count(Predicate<EntityType> ... predicates) {
        return 0;
    }

    public int count(Collection<Predicate<EntityType>> andPredicates, Collection<Predicate<EntityType>> orPredicates) {
        return 0;
    }

    public EntityType queryByPredicates(Predicate<EntityType> ... predicates) {
        return null;
    }

    private Optional<EntityType> getOptionalById(Integer id) {
        return this.data.stream().filter(m -> id.equals(m.getId())).findAny();
    }

    public EntityType queryById(Integer id) {
        return (EntityType)((GenericEntity)this.getOptionalById(id).orElseThrow(() -> new RuntimeException("Didn't find entity for id: " + id)));
    }

    public void delete(Integer id) {
        this.data.removeIf(e -> id.equals(e.getId()));
    }

    public void clear() {
        this.data.clear();
    }
}

