/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repositorymanager;

import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.mock.repositorymanager.RepositorySessionMock;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.spi.repositorymanager.BuildExecution;
import org.jboss.pnc.spi.repositorymanager.RepositoryManager;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerException;
import org.jboss.pnc.spi.repositorymanager.model.CompletedRepositoryDeletion;
import org.jboss.pnc.spi.repositorymanager.model.CompletedRepositoryPromotion;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.jboss.pnc.spi.repositorymanager.model.RunningRepositoryDeletion;
import org.jboss.pnc.spi.repositorymanager.model.RunningRepositoryPromotion;

@ApplicationScoped
public class RepositoryManagerMock
implements RepositoryManager {
    private Boolean promotionSuccess;
    private Exception promotionError;
    private Boolean deletionSuccess;
    private Exception deletionError;

    public RepositoryManagerMock expectPromotionSuccess(boolean promotionSuccess) {
        this.promotionSuccess = promotionSuccess;
        return this;
    }

    public RepositoryManagerMock expectPromotionError(Exception promotionError) {
        this.promotionError = promotionError;
        return this;
    }

    public RepositoryManagerMock expectDeletionSuccess(boolean deletionSuccess) {
        this.deletionSuccess = deletionSuccess;
        return this;
    }

    public RepositoryManagerMock expectDeletionError(Exception deletionError) {
        this.deletionError = deletionError;
        return this;
    }

    public RepositorySession createBuildRepository(BuildExecution buildExecution, String accessToken) throws RepositoryManagerException {
        RepositorySessionMock repositoryConfiguration = new RepositorySessionMock();
        return repositoryConfiguration;
    }

    public boolean canManage(TargetRepository.Type managerType) {
        return true;
    }

    public RunningRepositoryPromotion promoteBuild(BuildRecord buildRecord, String toGroup, String accessToken) throws RepositoryManagerException {
        return new RunningRepositoryPromotionMock(this.promotionSuccess, this.promotionError);
    }

    public RunningRepositoryDeletion deleteBuild(BuildRecord buildRecord, String accessToken) throws RepositoryManagerException {
        return new RunningRepositoryDeletionMock(this.deletionSuccess, this.deletionError);
    }

    public void close(String accessToken) {
    }

    public static final class RunningRepositoryDeletionMock
    implements RunningRepositoryDeletion {
        private Boolean status;
        private Exception error;

        public RunningRepositoryDeletionMock(Boolean status, Exception error) {
            this.status = status;
            this.error = error;
        }

        public void monitor(Consumer<CompletedRepositoryDeletion> onComplete, Consumer<Exception> onError) {
            if (this.status != null) {
                onComplete.accept(new CompletedRepositoryDeletion(){

                    public boolean isSuccessful() {
                        return status;
                    }
                });
            } else {
                onError.accept(this.error);
            }
        }
    }

    public static final class RunningRepositoryPromotionMock
    implements RunningRepositoryPromotion {
        private Boolean status;
        private Exception error;

        public RunningRepositoryPromotionMock(Boolean status, Exception error) {
            this.status = status;
            this.error = error;
        }

        public void monitor(Consumer<CompletedRepositoryPromotion> onComplete, Consumer<Exception> onError) {
            if (this.status != null) {
                onComplete.accept(new CompletedRepositoryPromotion(){

                    public boolean isSuccessful() {
                        return status;
                    }
                });
            } else {
                onError.accept(this.error);
            }
        }
    }
}

