/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.builddriver;

import java.util.function.Consumer;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildDriverBase {
    public static final Logger log = LoggerFactory.getLogger(BuildDriverBase.class);
    private BuildStatus buildStatus;

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) throws BuildDriverException {
        log.debug("Building " + buildExecutionSession.getId());
        Thread thread = new Thread(() -> {
            try {
                this.complete(buildExecutionSession, runningEnvironment, onComplete);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
        });
        thread.start();
        return this.createRunningBuild(runningEnvironment);
    }

    protected abstract RunningBuild createRunningBuild(RunningEnvironment var1);

    abstract void complete(BuildExecutionSession var1, RunningEnvironment var2, Consumer<CompletedBuild> var3) throws InterruptedException;

    protected void setBuildStatus(String buildScript) {
        this.buildStatus = buildScript.equals("mvn clean install -Dmock.config=Fail") ? BuildStatus.FAILED : (buildScript.equals("mvn clean install -Dmock.config=Cancel") ? BuildStatus.CANCELLED : BuildStatus.SUCCESS);
    }

    protected BuildDriverResult getBuildResultMock(RunningEnvironment runningEnvironment) {
        return new BuildDriverResult(){

            public String getBuildLog() {
                return "Building in workspace ... Finished: SUCCESS";
            }

            public BuildStatus getBuildStatus() {
                return BuildDriverBase.this.buildStatus;
            }
        };
    }
}

