/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;

public class BuildConfigurationAuditedRepositoryMock
implements BuildConfigurationAuditedRepository {
    private final AtomicInteger idSequence = new AtomicInteger(0);
    protected final List<BuildConfigurationAudited> data = new ArrayList<BuildConfigurationAudited>();

    public BuildConfigurationAudited save(BuildConfigurationAudited entity) {
        IdRev idRev = entity.getIdRev();
        if (idRev == null) {
            throw new IllegalStateException("auto-setting " + this.getClass().getSimpleName() + " entity id is not supported");
        }
        BuildConfiguration buildConfiguration = entity.getBuildConfiguration();
        Integer newRev = this.idSequence.getAndIncrement();
        BuildConfigurationAudited.fromBuildConfiguration((BuildConfiguration)buildConfiguration, (Integer)newRev);
        this.getOptionalById(idRev).ifPresent(this.data::remove);
        this.data.add(entity);
        return entity;
    }

    public List<BuildConfigurationAudited> queryAll() {
        return this.data;
    }

    public void delete(IdRev id) {
        this.data.removeIf(c -> c.getIdRev().equals((Object)id));
    }

    public List<BuildConfigurationAudited> findAllByIdOrderByRevDesc(Integer id) {
        return this.data.stream().filter(c -> c.getId().equals(id)).sorted((c1, c2) -> c2.getRev().compareTo(c1.getRev())).collect(Collectors.toList());
    }

    private Optional<BuildConfigurationAudited> getOptionalById(IdRev id) {
        return this.data.stream().filter(m -> id.equals((Object)m.getIdRev())).findAny();
    }

    public BuildConfigurationAudited queryById(IdRev id) {
        return this.getOptionalById(id).orElseThrow(() -> new RuntimeException("Didn't find entity for id: " + id));
    }

    public Map<IdRev, BuildConfigurationAudited> queryById(Set<IdRev> idRevs) {
        return idRevs.stream().map(idRev -> this.getOptionalById((IdRev)idRev).orElseThrow(() -> new RuntimeException("Didn't find entity for id: " + idRev))).collect(Collectors.toMap(BuildConfigurationAudited::getIdRev, bca -> bca));
    }

    public List<BuildConfigurationAudited> searchForBuildConfigurationName(String buildConfigurationName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public List<IdRev> searchIdRevForBuildConfigurationName(String buildConfigurationName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

