/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.pnc.common.util.CollectionUtils;
import org.jboss.pnc.mock.repository.RepositoryMock;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.GraphWithMetadata;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;

public class BuildRecordRepositoryMock
extends RepositoryMock<BuildRecord>
implements BuildRecordRepository {
    public BuildRecord findByIdFetchAllProperties(Integer id) {
        return (BuildRecord)this.queryById(id);
    }

    public BuildRecord findByIdFetchProperties(Integer id) {
        return (BuildRecord)this.queryById(id);
    }

    public List<BuildRecord> queryWithPredicatesUsingCursor(PageInfo pageInfo, SortInfo sortInfo, Predicate<BuildRecord> ... predicates) {
        return null;
    }

    public List<BuildRecord> queryWithPredicatesUsingCursor(PageInfo pageInfo, SortInfo sortInfo, List<Predicate<BuildRecord>> andPredicates, List<Predicate<BuildRecord>> orPredicates) {
        return null;
    }

    public BuildRecord getLatestSuccessfulBuildRecord(Integer configurationId, boolean temporaryBuild) {
        List<BuildRecord> buildRecords = this.queryAll();
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(configurationId, buildRecords, temporaryBuild);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(Integer configurationId, List<BuildRecord> buildRecords, boolean temporaryBuild) {
        return buildRecords.stream().filter(br -> br.getBuildConfigurationId().equals(configurationId)).filter(br -> br.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(br -> temporaryBuild || !br.isTemporaryBuild()).sorted(Comparator.comparing(BuildRecord::getId).reversed()).findFirst().orElse(null);
    }

    public List<BuildRecord> queryWithBuildConfigurationId(Integer configurationId) {
        return this.data.stream().filter(buildRecord -> buildRecord.getBuildConfigurationId().equals(configurationId)).collect(Collectors.toList());
    }

    public List<BuildRecord> findTemporaryBuildsOlderThan(Date date) {
        return null;
    }

    public GraphWithMetadata<BuildRecord, Integer> getDependencyGraph(Integer buildRecordId) {
        throw new UnsupportedOperationException();
    }

    public BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, boolean temporaryBuild) {
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(buildConfigurationAuditedIdRev, this.data);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, List<BuildRecord> buildRecords) {
        Optional<BuildRecord> first = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationAuditedIdRev().equals((Object)buildConfigurationAuditedIdRev)).sorted(Comparator.comparing(BuildRecord::getId).reversed()).findFirst();
        return first.orElse(null);
    }

    @Override
    public BuildRecord save(BuildRecord entity) {
        return super.save(entity);
    }

    @Override
    public List<BuildRecord> queryAll() {
        return super.queryAll();
    }

    public Set<BuildRecord> findByBuiltArtifacts(Set<Integer> artifactsId) {
        return this.data.stream().filter(buildRecord -> {
            Set builtArtifactsId = CollectionUtils.ofNullableCollection((Collection)buildRecord.getBuiltArtifacts()).stream().map(Artifact::getId).collect(Collectors.toSet());
            return !Collections.disjoint(artifactsId, builtArtifactsId);
        }).collect(Collectors.toSet());
    }
}

