/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.datastore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.PersistenceException;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.datastore.Datastore;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DatastoreMock
implements Datastore {
    private Logger log = LoggerFactory.getLogger((String)DatastoreMock.class.getName());
    private List<BuildRecord> buildRecords = Collections.synchronizedList(new ArrayList());
    private List<BuildConfigSetRecord> buildConfigSetRecords = Collections.synchronizedList(new ArrayList());
    private Map<Integer, BuildConfiguration> buildConfigurations = Collections.synchronizedMap(new HashMap());
    AtomicInteger buildRecordSequence = new AtomicInteger(0);
    AtomicInteger buildRecordSetSequence = new AtomicInteger(0);
    AtomicInteger buildConfigAuditedRevSequence = new AtomicInteger(0);

    public Map<Artifact, String> checkForBuiltArtifacts(Collection<Artifact> artifacts) {
        return new HashMap<Artifact, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildRecord storeCompletedBuild(BuildRecord.Builder buildRecordBuilder, List<Artifact> builtArtifacts, List<Artifact> dependencies) {
        buildRecordBuilder.dependencies(dependencies);
        BuildRecord buildRecord = (BuildRecord)Mockito.spy((Object)buildRecordBuilder.build());
        Mockito.when((Object)buildRecord.getBuiltArtifacts()).thenReturn(new HashSet<Artifact>(builtArtifacts));
        BuildConfiguration buildConfiguration = buildRecord.getBuildConfigurationAudited().getBuildConfiguration();
        this.log.info("Storing build " + buildConfiguration);
        DatastoreMock datastoreMock = this;
        synchronized (datastoreMock) {
            boolean exists = this.getBuildRecords().stream().anyMatch(br -> br.equals(buildRecord));
            if (exists) {
                throw new PersistenceException("Unique constraint violation, the record with id [" + buildRecord.getId() + "] already exists.");
            }
            this.buildRecords.add(buildRecord);
        }
        return buildRecord;
    }

    public BuildRecord storeRecordForNoRebuild(BuildRecord buildRecord) {
        this.buildRecords.add(buildRecord);
        return buildRecord;
    }

    public User retrieveUserByUsername(String username) {
        User user = new User();
        user.setUsername("demo-user");
        return user;
    }

    public List<BuildRecord> getBuildRecords() {
        return new ArrayList<BuildRecord>(this.buildRecords);
    }

    public List<BuildConfigSetRecord> getBuildConfigSetRecords() {
        return this.buildConfigSetRecords;
    }

    public void createNewUser(User user) {
    }

    public int getNextBuildRecordId() {
        return this.buildRecordSequence.incrementAndGet();
    }

    public BuildConfigSetRecord saveBuildConfigSetRecord(BuildConfigSetRecord buildConfigSetRecord) {
        if (buildConfigSetRecord.getId() == null) {
            buildConfigSetRecord.setId(Integer.valueOf(this.buildRecordSetSequence.incrementAndGet()));
        }
        this.log.info("Storing build config set record with id: " + buildConfigSetRecord);
        this.buildConfigSetRecords.add(buildConfigSetRecord);
        return buildConfigSetRecord;
    }

    public BuildConfigurationAudited getLatestBuildConfigurationAudited(Integer buildConfigId) {
        BuildConfiguration buildConfig = this.buildConfigurations.get(buildConfigId);
        int rev = this.buildConfigAuditedRevSequence.incrementAndGet();
        BuildConfigurationAudited buildConfigurationAudited = BuildConfigurationAudited.Builder.newBuilder().buildConfiguration(buildConfig).rev(Integer.valueOf(rev)).build();
        return buildConfigurationAudited;
    }

    public BuildConfigurationAudited getLatestBuildConfigurationAuditedLoadBCDependencies(Integer buildConfigurationId) {
        BuildConfiguration buildConfig = this.buildConfigurations.get(buildConfigurationId);
        int rev = this.buildConfigAuditedRevSequence.incrementAndGet();
        BuildConfigurationAudited buildConfigurationAudited = BuildConfigurationAudited.Builder.newBuilder().buildConfiguration(buildConfig).rev(Integer.valueOf(rev)).build();
        return buildConfigurationAudited;
    }

    public BuildConfigSetRecord getBuildConfigSetRecordById(Integer buildConfigSetRecordId) {
        return this.buildConfigSetRecords.stream().filter(bcsr -> bcsr.getId().equals(buildConfigSetRecordId)).findFirst().orElse(null);
    }

    public boolean requiresRebuild(BuildTask task, Set<Integer> processedDependenciesCache) {
        return true;
    }

    public Set<BuildConfiguration> getBuildConfigurations(BuildConfigurationSet buildConfigurationSet) {
        return buildConfigurationSet.getBuildConfigurations();
    }

    public boolean requiresRebuild(BuildConfigurationAudited buildConfigurationAudited, boolean checkImplicitDependencies, boolean temporaryBuild, Set<Integer> processedDependenciesCache, Consumer<BuildRecord> nonRebuildCauseSetter) {
        return true;
    }

    public BuildConfiguration save(BuildConfiguration buildConfig) {
        return this.buildConfigurations.put(buildConfig.getId(), buildConfig);
    }

    public void clear() {
        this.buildRecords.clear();
        this.buildConfigSetRecords.clear();
        this.buildConfigurations.clear();
        this.buildRecordSequence = new AtomicInteger(0);
        this.buildRecordSetSequence = new AtomicInteger(0);
        this.buildConfigAuditedRevSequence = new AtomicInteger(0);
    }
}

