/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.spi;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.mock.builddriver.BuildDriverResultMock;
import org.jboss.pnc.mock.environmentdriver.EnvironmentDriverResultMock;
import org.jboss.pnc.mock.executor.BuildExecutionConfigurationMock;
import org.jboss.pnc.mock.executor.BuildProcessExceptionMock;
import org.jboss.pnc.mock.repositorymanager.RepositoryManagerResultMock;
import org.jboss.pnc.mock.repour.RepourResultMock;
import org.jboss.pnc.mock.spi.DestroyableEnvironmentMock;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.coordinator.CompletionStatus;
import org.jboss.pnc.spi.coordinator.ProcessException;
import org.jboss.pnc.spi.environment.DestroyableEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;

public class BuildResultMock {
    public static BuildResult mock(BuildStatus status) {
        BuildExecutionConfiguration buildExecutionConfig = BuildExecutionConfigurationMock.mockConfig();
        BuildDriverResult buildDriverResult = BuildDriverResultMock.mockResult(status);
        RepositoryManagerResult repositoryManagerResult = RepositoryManagerResultMock.mockResult();
        ExecutorException exception = BuildResultMock.buildException();
        CompletionStatus completionStatus = status.completedSuccessfully() ? CompletionStatus.SUCCESS : CompletionStatus.FAILED;
        return new BuildResult(completionStatus, Optional.of(new ProcessException("Test Exception.")), "", Optional.ofNullable(buildExecutionConfig), Optional.ofNullable(buildDriverResult), Optional.ofNullable(repositoryManagerResult), Optional.of(EnvironmentDriverResultMock.mock()), Optional.of(RepourResultMock.mock()));
    }

    private static ExecutorException buildException() {
        DestroyableEnvironment destroyableEnvironment = DestroyableEnvironmentMock.build();
        return new ExecutorException("", (Exception)new CompletionException(new BuildProcessExceptionMock(new Exception(""), destroyableEnvironment)));
    }
}

