/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;

public abstract class RepositoryMock<ID extends Serializable, EntityType extends GenericEntity<ID>>
implements Repository<EntityType, ID> {
    protected final List<EntityType> data = new CopyOnWriteArrayList<EntityType>();

    public EntityType save(EntityType entity) {
        Serializable id = entity.getId();
        if (id == null) {
            entity.setId(this.getNextId());
            id = entity.getId();
        }
        this.getOptionalById(id).ifPresent(this.data::remove);
        this.data.add(entity);
        return entity;
    }

    public abstract ID getNextId();

    public List<EntityType> queryAll() {
        return this.data;
    }

    public List<EntityType> queryAll(PageInfo pageInfo, SortInfo sortInfo) {
        return Collections.emptyList();
    }

    public List<EntityType> queryWithPredicates(PageInfo pageInfo, SortInfo sortInfo, org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType> ... predicates) {
        return Collections.emptyList();
    }

    public List<EntityType> queryWithPredicates(org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType> ... predicates) {
        return Collections.emptyList();
    }

    public int count(org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType> ... predicates) {
        return 0;
    }

    public int count(Collection<org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType>> andPredicates, Collection<org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType>> orPredicates) {
        return 0;
    }

    public EntityType queryByPredicates(org.jboss.pnc.spi.datastore.repositories.api.Predicate<EntityType> ... predicates) {
        return null;
    }

    private Optional<EntityType> getOptionalById(ID id) {
        return this.data.stream().filter(m -> id.equals(m.getId())).findAny();
    }

    public EntityType queryById(ID id) {
        return (EntityType)((GenericEntity)this.getOptionalById(id).orElse(null));
    }

    public void delete(ID id) {
        this.data.removeIf(e -> id.equals(e.getId()));
    }

    public void flushAndRefresh(EntityType entity) {
    }

    public <D extends GenericEntity<ID>> void cascadeUpdates(D managedNonOwning, D updatedNonOwning, Function<D, Collection<EntityType>> collectionGetter, BiConsumer<EntityType, D> owningSetter, Predicate<EntityType> ... filters) {
        throw new UnsupportedOperationException("Not implemented, don't use");
    }

    public void clear() {
        this.data.clear();
    }
}

