/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.coordinator;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.pnc.common.logging.BuildTaskContext;
import org.jboss.pnc.enums.BuildCoordinationStatus;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.BuildTaskRef;
import org.jboss.pnc.spi.exception.CoreException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildCoordinatorMock
implements BuildCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<BuildTask> activeTasks = new ArrayList<BuildTask>();

    @Deprecated
    public BuildCoordinatorMock() {
    }

    public BuildSetTask buildConfig(BuildConfiguration buildConfiguration, User user, BuildOptions buildOptions) {
        logger.warn("Invoking unimplemented method build");
        return (BuildSetTask)Mockito.mock(BuildSetTask.class);
    }

    public void completeBuild(BuildTaskRef buildTask, Optional<BuildResult> buildResult) {
    }

    public BuildSetTask buildConfigurationAudited(BuildConfigurationAudited buildConfiguration, User user, BuildOptions buildOptions) {
        logger.warn("Invoking unimplemented method build");
        return (BuildSetTask)Mockito.mock(BuildSetTask.class);
    }

    public BuildSetTask buildSet(BuildConfigurationSet buildConfigurationSet, User user, BuildOptions buildOptions) {
        logger.warn("Invoking unimplemented method build");
        return (BuildSetTask)Mockito.mock(BuildSetTask.class);
    }

    public BuildSetTask buildSet(BuildConfigurationSet buildConfigurationSet, Map<Integer, BuildConfigurationAudited> buildConfigurationAuditedsMap, User user, BuildOptions buildOptions) throws CoreException {
        logger.warn("Invoking unimplemented method build");
        return (BuildSetTask)Mockito.mock(BuildSetTask.class);
    }

    public Optional<BuildTask> getSubmittedBuildTask(String buildId) {
        return this.activeTasks.stream().filter(buildTask -> buildTask.getId().equals(buildId)).findAny();
    }

    public List<BuildTask> getSubmittedBuildTasks() {
        return this.activeTasks;
    }

    public List<BuildTask> getSubmittedBuildTasksBySetId(long buildConfigSetRecordId) {
        return this.activeTasks.stream().filter(buildTask -> buildTask.getBuildSetTask().getBuildConfigSetRecord().isPresent() && ((BuildConfigSetRecord)buildTask.getBuildSetTask().getBuildConfigSetRecord().get()).getId().equals(buildConfigSetRecordId)).collect(Collectors.toList());
    }

    public void completeBuild(BuildTask buildTask, BuildResult buildResult) {
    }

    public boolean cancel(String buildTaskId) {
        return false;
    }

    public boolean cancelSet(long buildConfigSetRecordId) {
        return false;
    }

    public void updateBuildTaskStatus(BuildTask task, BuildCoordinationStatus status) {
    }

    public void updateBuildTaskStatus(BuildTaskRef task, BuildCoordinationStatus status) {
    }

    public void addActiveTask(BuildTask task) {
        this.activeTasks.add(task);
    }

    public void clearActiveTasks() {
        this.activeTasks.clear();
    }

    public Optional<BuildTaskContext> getMDCMeta(String buildTaskId) {
        return Optional.empty();
    }

    public void storeAndNotifyBuildConfigSetRecord(BuildConfigSetRecord setRecord, BuildStatus status, String description) {
    }

    public void start() {
    }
}

