/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.executor;

import java.net.URI;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.pnc.enums.BuildExecutionStatus;
import org.jboss.pnc.mock.executor.BuildExecutorStatusChangedEventMock;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.builddriver.BuildDriverResult;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.coordinator.CompletionStatus;
import org.jboss.pnc.spi.coordinator.ProcessException;
import org.jboss.pnc.spi.environment.EnvironmentDriverResult;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildExecutionSessionMock
implements BuildExecutionSession {
    private static final Logger log = LoggerFactory.getLogger(BuildExecutionSessionMock.class);
    private final BuildExecutionConfiguration buildExecutionConfiguration;
    private final Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent;
    private BuildExecutionStatus status;
    private ExecutorException executorException;
    private Optional<URI> liveLogsUri = Optional.empty();
    private Date startTime;
    private RunningEnvironment runningEnvironment;
    private Date endTime;
    private BuildDriverResult buildDriverResult;
    private RepositoryManagerResult repositoryManagerResult;
    private BuildExecutionStatus failedReasonStatus;
    private boolean cancelRequested = false;
    private Runnable cancelHook;
    private String accessToken;

    public BuildExecutionSessionMock(BuildExecutionConfiguration buildExecutionConfiguration, Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent) {
        this.buildExecutionConfiguration = buildExecutionConfiguration;
        this.onBuildExecutionStatusChangedEvent = onBuildExecutionStatusChangedEvent;
    }

    public Optional<URI> getLiveLogsUri() {
        return this.liveLogsUri;
    }

    public void setLiveLogsUri(Optional<URI> liveLogsUri) {
        this.liveLogsUri = liveLogsUri;
    }

    public void getEventLog() {
    }

    public BuildExecutionConfiguration getBuildExecutionConfiguration() {
        return this.buildExecutionConfiguration;
    }

    public BuildExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(BuildExecutionStatus status) {
        if (status.hasFailed() && this.failedReasonStatus == null) {
            if (status.equals((Object)BuildExecutionStatus.DONE_WITH_ERRORS)) {
                this.setException(new ExecutorException("Missing failedReasonStatus. Failed reason must be sat before final DONE_WITH_ERRORS."));
            }
            log.debug("Setting status {} as failed reason for session {}.", (Object)status, (Object)this.getId());
            this.failedReasonStatus = status;
        }
        Optional<Object> buildResult = status.isCompleted() ? Optional.of(this.getBuildResult()) : Optional.empty();
        BuildExecutorStatusChangedEventMock statusChanged = new BuildExecutorStatusChangedEventMock(this.status, status, this.getId(), null, buildResult, status.isCompleted());
        log.debug("Updating build execution task {} status to {}.", (Object)this.getId(), (Object)statusChanged);
        this.status = status;
        this.onBuildExecutionStatusChangedEvent.accept(statusChanged);
        log.debug("Fired events after build execution task {} update.", (Object)this.getId());
    }

    private BuildResult getBuildResult() {
        DebugData debugData;
        EnvironmentDriverResult environmentDriverResult = null;
        DebugData debugData2 = debugData = this.getRunningEnvironment() != null ? this.getRunningEnvironment().getDebugData() : null;
        if (debugData != null && debugData.isDebugEnabled()) {
            environmentDriverResult = new EnvironmentDriverResult(CompletionStatus.SUCCESS, "", Optional.of(debugData.getSshCredentials()));
        }
        CompletionStatus completionStatus = CompletionStatus.SUCCESS;
        if (this.executorException == null && this.failedReasonStatus != null) {
            switch (this.failedReasonStatus) {
                case BUILD_ENV_SETUP_COMPLETE_WITH_ERROR: 
                case COLLECTING_RESULTS_FROM_REPOSITORY_MANAGER_COMPLETED_WITH_ERROR: 
                case SYSTEM_ERROR: {
                    completionStatus = CompletionStatus.SYSTEM_ERROR;
                    break;
                }
                case BUILD_COMPLETED_WITH_ERROR: {
                    completionStatus = CompletionStatus.FAILED;
                    break;
                }
                case CANCELLED: {
                    completionStatus = CompletionStatus.CANCELLED;
                    break;
                }
                case DONE_WITH_ERRORS: {
                    this.executorException = new ExecutorException("DONE_WITH_ERRORS cannot be set as failed reason.");
                }
            }
        }
        ProcessException processException = null;
        if (this.executorException != null) {
            processException = new ProcessException((Throwable)this.executorException);
            completionStatus = CompletionStatus.SYSTEM_ERROR;
        }
        log.debug("Returning result of task {}.", (Object)this.getId());
        return new BuildResult(completionStatus, Optional.ofNullable(processException), "", Optional.ofNullable(this.buildExecutionConfiguration), Optional.ofNullable(this.buildDriverResult), Optional.ofNullable(this.repositoryManagerResult), Optional.ofNullable(environmentDriverResult), Optional.empty());
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ExecutorException getException() {
        return this.executorException;
    }

    public void setException(ExecutorException executorException) {
        log.debug("Setting exception: {}", (Object)(executorException != null ? executorException.getMessage() : "null"));
        this.executorException = executorException;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean hasFailed() {
        log.debug("Has failed ? executorException: {} || failedReasonStatus: {}", (Object)(this.executorException == null ? "" : this.executorException.getMessage()), (Object)this.failedReasonStatus);
        return this.executorException != null || this.failedReasonStatus != null;
    }

    public String getId() {
        return this.getBuildExecutionConfiguration().getId();
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public RunningEnvironment getRunningEnvironment() {
        return this.runningEnvironment;
    }

    public void setRunningEnvironment(RunningEnvironment runningEnvironment) {
        this.runningEnvironment = runningEnvironment;
    }

    public void setBuildDriverResult(BuildDriverResult buildDriverResult) {
        this.buildDriverResult = buildDriverResult;
    }

    public BuildDriverResult getBuildDriverResult() {
        return this.buildDriverResult;
    }

    public void setRepositoryManagerResult(RepositoryManagerResult repositoryManagerResult) {
        this.repositoryManagerResult = repositoryManagerResult;
    }

    public synchronized void setCancelHook(Runnable cancelHook) {
        this.cancelHook = cancelHook;
    }

    public synchronized void cancel() {
        this.cancelRequested = true;
        if (this.cancelHook != null) {
            this.cancelHook.run();
        } else {
            log.warn("Trying to cancel operation while no cancel hook is defined.");
        }
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

