/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.spi;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.pnc.mock.model.builders.ArtifactBuilder;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.spi.coordinator.CompletionStatus;
import org.jboss.pnc.spi.repositorymanager.RepositoryManagerResult;

public class RepositoryManagerResultMock {
    private static AtomicInteger rebuildNumber = new AtomicInteger();

    public static RepositoryManagerResult mockResult() {
        return RepositoryManagerResultMock.mockResult(false);
    }

    public static RepositoryManagerResult mockResult(boolean failed) {
        int rebuild = rebuildNumber.getAndAdd(100);
        return RepositoryManagerResultMock.mockResult(failed, rebuild);
    }

    public static RepositoryManagerResult mockResult(final boolean failed, final int base) {
        return new RepositoryManagerResult(){

            public List<Artifact> getBuiltArtifacts() {
                Artifact[] artifacts = new Artifact[]{ArtifactBuilder.mockArtifact(base + 11), ArtifactBuilder.mockArtifact(base + 12)};
                return Arrays.asList(artifacts);
            }

            public List<Artifact> getDependencies() {
                Artifact[] artifacts = new Artifact[]{ArtifactBuilder.mockImportedArtifact(base + 21), ArtifactBuilder.mockImportedArtifact(base + 22), ArtifactBuilder.mockArtifact(base + 13)};
                return Arrays.asList(artifacts);
            }

            public String getBuildContentId() {
                return "mock-content-id";
            }

            public String getLog() {
                if (failed) {
                    return "MOCK: Validation of org.jboss.pnc:pnc-mock:1.0 failed due to: invalid pom file.";
                }
                return "MOCK: Repository manager has promoted all collected artifacts.";
            }

            public CompletionStatus getCompletionStatus() {
                if (failed) {
                    return CompletionStatus.FAILED;
                }
                return CompletionStatus.SUCCESS;
            }
        };
    }
}

