/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.common.util.CollectionUtils;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.mock.repository.Base32LongIdRepositoryMock;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

public class BuildRecordRepositoryMock
extends Base32LongIdRepositoryMock<BuildRecord>
implements BuildRecordRepository {
    public BuildRecord findByIdFetchAllProperties(Base32LongID id) {
        return (BuildRecord)this.queryById(id);
    }

    public BuildRecord findByIdFetchProperties(Base32LongID id) {
        return (BuildRecord)this.queryById(id);
    }

    public BuildRecord getLatestSuccessfulBuildRecord(Integer configurationId, boolean temporaryBuild) {
        List<BuildRecord> buildRecords = this.queryAll();
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(configurationId, buildRecords, temporaryBuild);
    }

    public BuildRecord getAnyLatestSuccessfulBuildRecordWithBuildConfig(Integer configurationId, boolean temporaryBuild) {
        List<BuildRecord> buildRecords = this.queryAll();
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(configurationId, buildRecords, temporaryBuild);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(Integer configurationId, List<BuildRecord> buildRecords, boolean temporaryBuild) {
        return buildRecords.stream().filter(br -> br.getBuildConfigurationId().equals(configurationId)).filter(br -> br.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(br -> temporaryBuild || !br.isTemporaryBuild()).max(Comparator.comparing(BuildRecord::getSubmitTime)).orElse(null);
    }

    public List<BuildRecord> queryWithBuildConfigurationId(Integer configurationId) {
        return this.data.stream().filter(buildRecord -> buildRecord.getBuildConfigurationId().equals(configurationId)).collect(Collectors.toList());
    }

    public List<BuildRecord> queryWithBuildConfigurationSetRecordId(Base32LongID bcsrId) {
        return this.data.stream().filter(br -> br.getBuildConfigSetRecord() != null && br.getBuildConfigSetRecord().getId().equals((Object)bcsrId)).collect(Collectors.toList());
    }

    public List<BuildRecord> findIndependentTemporaryBuildsOlderThan(Date date) {
        return null;
    }

    public BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, boolean temporaryBuild) {
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(buildConfigurationAuditedIdRev, this.data);
    }

    public BuildRecord getAnyLatestSuccessfulBuildRecordWithRevision(IdRev buildConfigurationAuditedIdRev, boolean temporaryBuild) {
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(buildConfigurationAuditedIdRev, (List<BuildRecord>)this.data, temporaryBuild);
    }

    public BuildRecord getPreferredLatestSuccessfulBuildRecordWithRevision(IdRev buildConfigurationAuditedIdRev, boolean temporaryBuild, AlignmentPreference alignmentPreference) {
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(buildConfigurationAuditedIdRev, (List<BuildRecord>)this.data, temporaryBuild, alignmentPreference);
    }

    public BuildRecord getPreferredLatestSuccessfulBuildRecordWithBuildConfig(Integer configurationId, boolean temporaryBuild, AlignmentPreference alignmentPreference) {
        return BuildRecordRepositoryMock.getLatestSuccessfulBuildRecord(configurationId, (List<BuildRecord>)this.data, temporaryBuild, alignmentPreference);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, List<BuildRecord> buildRecords) {
        Optional<BuildRecord> first = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationAuditedIdRev().equals((Object)buildConfigurationAuditedIdRev)).max(Comparator.comparing(BuildRecord::getSubmitTime));
        return first.orElse(null);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, List<BuildRecord> buildRecords, boolean temporaryBuild) {
        Optional<BuildRecord> first = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationAuditedIdRev().equals((Object)buildConfigurationAuditedIdRev)).filter(buildRecord -> temporaryBuild || !buildRecord.isTemporaryBuild()).max(Comparator.comparing(BuildRecord::getSubmitTime));
        return first.orElse(null);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(IdRev buildConfigurationAuditedIdRev, List<BuildRecord> buildRecords, boolean temporaryBuild, AlignmentPreference alignmentPreference) {
        Optional<BuildRecord> latestPersistent = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationAuditedIdRev().equals((Object)buildConfigurationAuditedIdRev)).filter(buildRecord -> !buildRecord.isTemporaryBuild()).max(Comparator.comparing(BuildRecord::getSubmitTime));
        Optional<BuildRecord> latestTemporary = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationAuditedIdRev().equals((Object)buildConfigurationAuditedIdRev)).filter(BuildRecord::isTemporaryBuild).max(Comparator.comparing(BuildRecord::getSubmitTime));
        if (temporaryBuild) {
            if (AlignmentPreference.PREFER_TEMPORARY.equals((Object)alignmentPreference)) {
                return latestTemporary.orElse(latestPersistent.orElse(null));
            }
            return latestPersistent.orElse(latestTemporary.orElse(null));
        }
        return latestPersistent.orElse(null);
    }

    public static BuildRecord getLatestSuccessfulBuildRecord(Integer configurationId, List<BuildRecord> buildRecords, boolean temporaryBuild, AlignmentPreference alignmentPreference) {
        Optional<BuildRecord> latestPersistent = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationId().equals(configurationId)).filter(buildRecord -> !buildRecord.isTemporaryBuild()).max(Comparator.comparing(BuildRecord::getSubmitTime));
        Optional<BuildRecord> latestTemporary = buildRecords.stream().filter(buildRecord -> buildRecord.getStatus().equals((Object)BuildStatus.SUCCESS)).filter(buildRecord -> buildRecord.getBuildConfigurationId().equals(configurationId)).filter(BuildRecord::isTemporaryBuild).max(Comparator.comparing(BuildRecord::getSubmitTime));
        if (temporaryBuild) {
            if (AlignmentPreference.PREFER_TEMPORARY.equals((Object)alignmentPreference)) {
                return latestTemporary.orElse(latestPersistent.orElse(null));
            }
            return latestPersistent.orElse(latestTemporary.orElse(null));
        }
        return latestPersistent.orElse(null);
    }

    public List<BuildRecord> getLatestBuildsForBuildConfigs(List<Integer> configIds) {
        return null;
    }

    @Override
    public BuildRecord save(BuildRecord entity) {
        return super.save(entity);
    }

    @Override
    public List<BuildRecord> queryAll() {
        return super.queryAll();
    }

    public Set<BuildRecord> findByBuiltArtifacts(Set<Integer> artifactsId) {
        return this.data.stream().filter(buildRecord -> {
            Set builtArtifactsId = CollectionUtils.ofNullableCollection((Collection)buildRecord.getBuiltArtifacts()).stream().map(Artifact::getId).collect(Collectors.toSet());
            return !Collections.disjoint(artifactsId, builtArtifactsId);
        }).collect(Collectors.toSet());
    }

    public List<BuildRecord> getBuildByCausingRecord(Base32LongID causingRecordId) {
        return null;
    }

    public List<Object[]> getAllBuildRecordInsightsNewerThanTimestamp(Date lastupdatetime, int pageSize, int offset) {
        return null;
    }

    public int countAllBuildRecordInsightsNewerThanTimestamp(Date lastupdatetime) {
        return 0;
    }

    public List<Base32LongID> queryIdsWithPredicates(Predicate<BuildRecord> ... predicates) {
        return List.of();
    }

    public List<Tuple> getImplicitDependencies(Base32LongID buildId) {
        return List.of();
    }

    public List<Tuple> getImplicitDependants(Base32LongID buildId) {
        return List.of();
    }
}

