/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.datastore;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.spi.coordinator.BuildTaskRef;
import org.jboss.pnc.spi.datastore.BuildTaskRepository;
import org.jboss.pnc.spi.exception.RemoteRequestException;

@ApplicationScoped
public class BuildTaskRepositoryMock
implements BuildTaskRepository {
    private final Map<String, BuildTaskRef> tasks = new ConcurrentHashMap<String, BuildTaskRef>();

    public BuildTaskRef getTask(String id) {
        return this.tasks.get(id);
    }

    public Optional<BuildTaskRef> getSpecific(String taskId) throws RemoteRequestException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<BuildTaskRef> getBuildTasksByBCSRId(Base32LongID buildConfigSetRecordId) {
        return this.tasks.values().stream().filter(t -> buildConfigSetRecordId.equals((Object)t.getBuildConfigSetRecordId())).collect(Collectors.toList());
    }

    @Deprecated
    public Collection<? extends BuildTaskRef> getAll() {
        return this.tasks.values();
    }

    public Collection<BuildTaskRef> getUnfinishedTasks() {
        return this.tasks.values().stream().filter(task -> !task.getStatus().isCompleted()).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty() || this.tasks.values().stream().allMatch(task -> task.getStatus().isCompleted());
    }

    public String getDebugInfo() {
        return "null";
    }

    public void addTask(BuildTaskRef task) {
        this.tasks.put(task.getId(), task);
    }

    public void removeTask(BuildTaskRef task) {
        this.tasks.remove(task.getId());
    }

    public void clear() {
        this.tasks.clear();
    }
}

