/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.datastore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.PersistenceException;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.datastore.Datastore;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DatastoreMock
implements Datastore {
    private Logger log = LoggerFactory.getLogger((String)DatastoreMock.class.getName());
    private List<BuildRecord> buildRecords = Collections.synchronizedList(new ArrayList());
    private List<BuildConfigSetRecord> buildConfigSetRecords = Collections.synchronizedList(new ArrayList());
    private Map<Integer, BuildConfiguration> buildConfigurations = Collections.synchronizedMap(new HashMap());
    private Map<Integer, List<BuildConfigurationAudited>> buildConfigurationsAudited = Collections.synchronizedMap(new HashMap());
    AtomicLong buildRecordSetSequence = new AtomicLong(0L);
    AtomicInteger buildConfigAuditedRevSequence = new AtomicInteger(0);
    private Set<IdRev> noRebuildRequiresIdRevs = new HashSet<IdRev>();

    public Map<Artifact, String> checkForBuiltArtifacts(Collection<Artifact> artifacts) {
        return new HashMap<Artifact, String>();
    }

    public BuildConfigurationAudited getBuildConfigurationAudited(IdRev idRev) {
        return this.buildConfigurationsAudited.entrySet().stream().filter(entry -> ((Integer)entry.getKey()).equals(idRev.id)).flatMap(entry -> ((List)entry.getValue()).stream()).filter(bca -> bca.getIdRev().getRev().equals(idRev.rev)).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildRecord storeCompletedBuild(BuildRecord.Builder buildRecordBuilder, List<Artifact> builtArtifacts, List<Artifact> dependencies) {
        buildRecordBuilder.dependencies(dependencies);
        BuildRecord buildRecord = (BuildRecord)Mockito.spy((Object)buildRecordBuilder.build());
        Mockito.when((Object)buildRecord.getBuiltArtifacts()).thenReturn(new HashSet<Artifact>(builtArtifacts));
        BuildConfiguration buildConfiguration = buildRecord.getBuildConfigurationAudited().getBuildConfiguration();
        this.log.info("Storing build " + buildConfiguration);
        DatastoreMock datastoreMock = this;
        synchronized (datastoreMock) {
            boolean exists = this.getBuildRecords().stream().anyMatch(br -> br.equals((Object)buildRecord));
            if (exists) {
                throw new PersistenceException("Unique constraint violation, the record with id [" + buildRecord.getId() + "] already exists.");
            }
            if (buildRecord.getBuildConfigSetRecord() != null) {
                buildRecord.getBuildConfigSetRecord().getBuildRecords().add(buildRecord);
            }
            this.buildRecords.add(buildRecord);
            this.log.debug("[{}]Build records after storing: {}", (Object)this.hashCode(), this.buildRecords);
        }
        return buildRecord;
    }

    public BuildRecord storeRecordForNoRebuild(BuildRecord buildRecord) {
        this.buildRecords.add(buildRecord);
        return buildRecord;
    }

    public User retrieveUserByUsername(String username) {
        User user = new User();
        user.setUsername("demo-user");
        return user;
    }

    public List<BuildRecord> getBuildRecords() {
        this.log.info("[{}]Getting build records {}", (Object)this.hashCode(), this.buildRecords);
        return new ArrayList<BuildRecord>(this.buildRecords);
    }

    public List<BuildConfigSetRecord> getBuildConfigSetRecords() {
        return this.buildConfigSetRecords;
    }

    public void createNewUser(User user) {
    }

    public BuildConfigSetRecord saveBuildConfigSetRecord(BuildConfigSetRecord buildConfigSetRecord) {
        if (buildConfigSetRecord.getId() == null) {
            buildConfigSetRecord.setId(new Base32LongID(Sequence.nextId().longValue()));
        }
        this.log.info("Storing build config set record with id: " + buildConfigSetRecord);
        this.buildConfigSetRecords.add(buildConfigSetRecord);
        return buildConfigSetRecord;
    }

    public BuildConfigurationAudited getLatestBuildConfigurationAudited(Integer buildConfigId) {
        BuildConfiguration buildConfig = this.buildConfigurations.get(buildConfigId);
        int rev = this.buildConfigAuditedRevSequence.incrementAndGet();
        BuildConfigurationAudited buildConfigurationAudited = BuildConfigurationAudited.Builder.newBuilder().buildConfiguration(buildConfig).rev(Integer.valueOf(rev)).build();
        return buildConfigurationAudited;
    }

    public BuildConfigurationAudited getLatestBuildConfigurationAuditedLoadBCDependencies(Integer buildConfigurationId) {
        List<BuildConfigurationAudited> auditedList = this.buildConfigurationsAudited.get(buildConfigurationId);
        return auditedList.get(auditedList.size() - 1);
    }

    public BuildConfigSetRecord getBuildConfigSetRecordById(Base32LongID buildConfigSetRecordId) {
        return this.buildConfigSetRecords.stream().filter(bcsr -> bcsr.getId().equals((Object)buildConfigSetRecordId)).findFirst().orElse(null);
    }

    public boolean requiresRebuild(BuildTask task, Set<Integer> processedDependenciesCache) {
        return true;
    }

    public Set<BuildConfiguration> getBuildConfigurations(BuildConfigurationSet buildConfigurationSet) {
        return buildConfigurationSet.getBuildConfigurations();
    }

    public Collection<BuildConfigSetRecord> findBuildConfigSetRecordsInProgress() {
        return this.buildConfigSetRecords.stream().filter(r -> !r.getStatus().isFinal()).collect(Collectors.toList());
    }

    public boolean requiresRebuild(BuildConfigurationAudited buildConfigurationAudited, boolean checkImplicitDependencies, boolean temporaryBuild, AlignmentPreference alignmentPreference, Set<Integer> processedDependenciesCache, Consumer<BuildRecord> nonRebuildCauseSetter) {
        if (this.noRebuildRequiresIdRevs.contains(buildConfigurationAudited.getIdRev())) {
            nonRebuildCauseSetter.accept(BuildRecord.Builder.newBuilder().id(new Base32LongID(Sequence.nextId().longValue())).build());
            return false;
        }
        return true;
    }

    public BuildConfiguration save(BuildConfiguration buildConfig) {
        return this.saveBCA(buildConfig).getBuildConfiguration();
    }

    public BuildConfigurationAudited saveBCA(BuildConfiguration buildConfig) {
        List auditedConfigs = this.buildConfigurationsAudited.computeIfAbsent(buildConfig.getId(), k -> new ArrayList());
        BuildConfigurationAudited bca = BuildConfigurationAudited.fromBuildConfiguration((BuildConfiguration)buildConfig, (Integer)this.buildConfigAuditedRevSequence.getAndIncrement());
        auditedConfigs.add(bca);
        this.buildConfigurations.put(buildConfig.getId(), bca.getBuildConfiguration());
        return bca;
    }

    public void clear() {
        this.log.info("Clearing build records");
        this.buildRecords.clear();
        this.buildConfigSetRecords.clear();
        this.buildConfigurations.clear();
        this.buildRecordSetSequence = new AtomicLong(0L);
        this.buildConfigAuditedRevSequence = new AtomicInteger(0);
    }

    public boolean addNoRebuildRequiredBCAIdREv(IdRev idRev) {
        return this.noRebuildRequiresIdRevs.add(idRev);
    }

    public boolean removeNoRebuildRequiredBCAIdREv(IdRev idRev) {
        return this.noRebuildRequiresIdRevs.remove(idRev);
    }
}

