/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mock.coordinator;

import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.common.util.TimeUtils;
import org.jboss.pnc.enums.BuildType;
import org.jboss.pnc.enums.SystemImageType;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.utils.ContentIdentityManager;
import org.jboss.pnc.spi.BuildResult;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildScheduler;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.InMemory;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutor;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
public class LocalBuildScheduler
implements BuildScheduler {
    private static final Logger log = LoggerFactory.getLogger(LocalBuildScheduler.class);
    protected BuildExecutor buildExecutor;
    @InMemory
    protected BuildCoordinator buildCoordinator;

    @Deprecated
    public LocalBuildScheduler() {
    }

    @Inject
    public LocalBuildScheduler(BuildExecutor buildExecutor, BuildCoordinator buildCoordinator) {
        this.buildExecutor = buildExecutor;
        this.buildCoordinator = buildCoordinator;
    }

    public void startBuilding(BuildTask buildTask) throws CoreException {
        Consumer<BuildExecutionStatusChangedEvent> onBuildExecutionStatusChangedEvent = statusChangedEvent -> {
            try {
                log.debug("Received execution status update {}.", statusChangedEvent);
                if (statusChangedEvent.getNewStatus().isCompleted()) {
                    BuildResult buildResult = (BuildResult)statusChangedEvent.getBuildResult().get();
                    log.debug("Notifying build execution completed {}.", statusChangedEvent);
                    this.buildCoordinator.completeBuild(buildTask, buildResult);
                }
            }
            catch (Throwable t) {
                log.error("Failed to notify build completion.", t);
            }
        };
        String contentId = ContentIdentityManager.getBuildContentId((String)buildTask.getId());
        BuildConfigurationAudited configuration = buildTask.getBuildConfigurationAudited();
        BuildExecutionConfiguration buildExecutionConfiguration = BuildExecutionConfiguration.build((String)buildTask.getId(), (String)contentId, (String)buildTask.getUser().getId().toString(), (String)configuration.getBuildScript(), (String)configuration.getId().toString(), (String)configuration.getName(), (String)configuration.getRepositoryConfiguration().getInternalUrl(), (String)configuration.getScmRevision(), null, (String)configuration.getScmRevision(), (Boolean)false, (String)configuration.getRepositoryConfiguration().getExternalUrl(), (boolean)configuration.getRepositoryConfiguration().isPreBuildSyncEnabled(), (String)configuration.getBuildEnvironment().getSystemImageId(), (String)configuration.getBuildEnvironment().getSystemImageRepositoryUrl(), (SystemImageType)configuration.getBuildEnvironment().getSystemImageType(), (BuildType)configuration.getBuildType(), (boolean)buildTask.getBuildOptions().isKeepPodOnFailure(), (Map)configuration.getGenericParameters(), (boolean)buildTask.getBuildOptions().isTemporaryBuild(), (String)TimeUtils.generateTimestamp((boolean)buildTask.getBuildOptions().isTimestampAlignment(), (Date)buildTask.getStartTime()), (boolean)configuration.isBrewPullActive(), (String)configuration.getDefaultAlignmentParams(), (AlignmentPreference)buildTask.getBuildOptions().getAlignmentPreference());
        try {
            this.buildExecutor.startBuilding(buildExecutionConfiguration, onBuildExecutionStatusChangedEvent, buildTask.getUser().getLoginToken());
        }
        catch (ExecutorException e) {
            throw new CoreException("Could not start build execution.", (Exception)((Object)e));
        }
    }

    public void startBuilding(BuildSetTask buildSetTask) throws CoreException {
        for (BuildTask buildTask : buildSetTask.getBuildTasks()) {
            this.startBuilding(buildTask);
        }
    }

    public boolean cancel(BuildTask buildTask) throws CoreException {
        try {
            this.buildExecutor.cancel(buildTask.getId());
        }
        catch (ExecutorException e) {
            throw new CoreException("Cannot cancel buildTask " + buildTask.getId(), (Exception)((Object)e));
        }
        return false;
    }
}

