/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.bpm.BpmEventType;
import org.jboss.pnc.bpm.BpmManager;
import org.jboss.pnc.bpm.BpmTask;
import org.jboss.pnc.bpm.task.MilestoneReleaseTask;
import org.jboss.pnc.common.util.CollectionUtils;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.MilestoneReleaseStatus;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductMilestoneRelease;
import org.jboss.pnc.rest.restmodel.bpm.BpmNotificationRest;
import org.jboss.pnc.rest.restmodel.bpm.BpmStringMapNotificationRest;
import org.jboss.pnc.rest.restmodel.causeway.ArtifactImportError;
import org.jboss.pnc.rest.restmodel.causeway.BuildImportResultRest;
import org.jboss.pnc.rest.restmodel.causeway.BuildImportStatus;
import org.jboss.pnc.rest.restmodel.causeway.MilestoneReleaseResultRest;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.exception.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class ProductMilestoneReleaseManager {
    private static final Logger log = LoggerFactory.getLogger(ProductMilestoneReleaseManager.class);
    public static final String BREW_ID = "brewId";
    public static final String BREW_LINK = "brewLink";
    private BpmManager bpmManager;
    private ArtifactRepository artifactRepository;
    private BuildRecordRepository buildRecordRepository;
    private ProductMilestoneReleaseRepository releaseRepository;
    private ProductMilestoneRepository milestoneRepository;

    @Deprecated
    public ProductMilestoneReleaseManager() {
    }

    @Inject
    public ProductMilestoneReleaseManager(ProductMilestoneReleaseRepository releaseRepository, BpmManager bpmManager, ArtifactRepository artifactRepository, BuildRecordRepository buildRecordRepository, ProductMilestoneRepository milestoneRepository) {
        this.releaseRepository = releaseRepository;
        this.bpmManager = bpmManager;
        this.artifactRepository = artifactRepository;
        this.buildRecordRepository = buildRecordRepository;
        this.milestoneRepository = milestoneRepository;
    }

    public void startRelease(ProductMilestone milestone, String accessToken) {
        ProductMilestoneRelease release = this.triggerRelease(milestone, accessToken);
        this.releaseRepository.save((GenericEntity)release);
    }

    public boolean noReleaseInProgress(ProductMilestone milestone) {
        ProductMilestoneRelease latestRelease = this.releaseRepository.findLatestByMilestone(milestone);
        return latestRelease == null || latestRelease.getStatus() != MilestoneReleaseStatus.IN_PROGRESS;
    }

    private <T extends BpmNotificationRest> ProductMilestoneRelease triggerRelease(ProductMilestone milestone, String accessToken) {
        ProductMilestoneRelease release = new ProductMilestoneRelease();
        release.setStartingDate(new Date());
        release.setMilestone(milestone);
        try {
            MilestoneReleaseTask releaseTask = new MilestoneReleaseTask(milestone, accessToken);
            Integer id = milestone.getId();
            releaseTask.addListener(BpmEventType.BREW_IMPORT_SUCCESS, r -> this.onSuccessfulPush(id, (MilestoneReleaseResultRest)r));
            releaseTask.addListener(BpmEventType.BREW_IMPORT_ERROR, r -> this.onFailedPush(milestone.getId(), (BpmStringMapNotificationRest)r));
            this.bpmManager.startTask((BpmTask)releaseTask);
            release.setLog("Brew push task started\n");
            return release;
        }
        catch (CoreException e) {
            log.error("Error trying to start brew push task for milestone: {}", (Object)milestone.getId(), (Object)e);
            release.setLog("Brew push BPM task creation failed.\nCheck log for more details.\n");
            release.setStatus(MilestoneReleaseStatus.SYSTEM_ERROR);
            release.setEndDate(new Date());
            return release;
        }
    }

    private void onSuccessfulPush(Integer milestoneId, MilestoneReleaseResultRest result) {
        log.debug("Storing milestone release result: {}", (Object)result);
        this.withMilestone(milestoneId, result, this::storeSuccess);
    }

    private void onFailedPush(Integer milestoneId, BpmStringMapNotificationRest result) {
        log.debug("Storing failed milestone release result: {}", (Object)result);
        this.withMilestone(milestoneId, result, this::storeFailure);
    }

    private <T> void withMilestone(Integer milestoneId, T result, BiConsumer<ProductMilestone, T> consumer) {
        ProductMilestone milestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)milestoneId);
        if (milestone == null) {
            log.error("No milestone found for milestone id {}", (Object)milestoneId);
            return;
        }
        consumer.accept(milestone, (ProductMilestone)result);
    }

    private void storeSuccess(ProductMilestone milestone, MilestoneReleaseResultRest result) {
        String message = this.describeCompletedPush(result);
        this.updateRelease(milestone, message, result.getReleaseStatus().getMilestoneReleaseStatus());
        for (BuildImportResultRest buildRest : CollectionUtils.ofNullableCollection((Collection)result.getBuilds())) {
            this.storeBrewBuildParameters(buildRest);
        }
    }

    private <T> void storeFailure(ProductMilestone milestone, BpmStringMapNotificationRest result) {
        this.updateRelease(milestone, "BREW IMPORT FAILED\nResult: " + result, MilestoneReleaseStatus.SYSTEM_ERROR);
    }

    private void storeBrewBuildParameters(BuildImportResultRest buildRest) {
        Integer recordId = buildRest.getBuildRecordId();
        BuildRecord record = (BuildRecord)this.buildRecordRepository.queryById((Serializable)recordId);
        if (record == null) {
            log.error("No record found for record id: {}, skipped saving info: {}", (Object)recordId, (Object)buildRest);
            return;
        }
        Integer brewBuildId = buildRest.getBrewBuildId();
        String brewBuildUrl = buildRest.getBrewBuildUrl();
        if (brewBuildId != null) {
            record.putAttribute(BREW_ID, String.valueOf(brewBuildId));
        }
        if (brewBuildUrl != null) {
            record.putAttribute(BREW_LINK, brewBuildUrl);
        }
        this.buildRecordRepository.save((GenericEntity)record);
    }

    private void updateRelease(ProductMilestone milestone, String message, MilestoneReleaseStatus status) {
        ProductMilestoneRelease release = this.releaseRepository.findLatestByMilestone(milestone);
        if (release == null) {
            log.error("No milestone release found for milestone {}", (Object)milestone.getId());
            return;
        }
        if (status != MilestoneReleaseStatus.IN_PROGRESS) {
            release.setEndDate(new Date());
        }
        release.setStatus(status);
        release.setLog(release.getLog() + message);
        this.releaseRepository.save((GenericEntity)release);
    }

    private String describeCompletedPush(MilestoneReleaseResultRest result) {
        boolean success = result.isSuccessful();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Brew push ").append(success ? "SUCCEEDED" : "FAILED").append("\n");
        stringBuilder.append("Import details:\n");
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            stringBuilder.append(errorMessage).append("\n");
        }
        for (BuildImportResultRest buildImport : result.getBuilds()) {
            this.describeBuildImport(stringBuilder, buildImport);
        }
        return stringBuilder.toString();
    }

    private void describeBuildImport(StringBuilder stringBuilder, BuildImportResultRest buildImport) {
        Integer buildRecordId = buildImport.getBuildRecordId();
        BuildRecord record = ProductMilestoneReleaseManager.orNull(buildRecordId, arg_0 -> ((BuildRecordRepository)this.buildRecordRepository).queryById(arg_0));
        BuildConfigurationAudited buildConfiguration = ProductMilestoneReleaseManager.orNull(record, BuildRecord::getBuildConfigurationAudited);
        stringBuilder.append("\n-------------------------------------------------------------------------\n");
        String buildMessage = String.format("%s [buildRecordId: %d, built from %s rev %s] import %s. Brew build id: %d, Brew build url: %s\n", ProductMilestoneReleaseManager.orNull(buildConfiguration, BuildConfigurationAudited::getName), ProductMilestoneReleaseManager.orNull(record, BuildRecord::getId), ProductMilestoneReleaseManager.orNull(record, BuildRecord::getScmRepoURL), ProductMilestoneReleaseManager.orNull(record, BuildRecord::getScmRevision), buildImport.getStatus(), buildImport.getBrewBuildId(), buildImport.getBrewBuildUrl());
        stringBuilder.append(buildMessage);
        if (buildImport.getStatus() != BuildImportStatus.SUCCESSFUL) {
            stringBuilder.append("Error message: ").append(buildImport.getErrorMessage());
            List errors = buildImport.getErrors();
            if (errors != null && !errors.isEmpty()) {
                errors.forEach(e -> this.describeArtifactImportError(stringBuilder, (ArtifactImportError)e));
            }
        }
        stringBuilder.append("\n");
    }

    private void describeArtifactImportError(StringBuilder stringBuilder, ArtifactImportError e) {
        Integer artifactId = e.getArtifactId();
        Artifact artifact = (Artifact)this.artifactRepository.queryById((Serializable)artifactId);
        stringBuilder.append(String.format("Failed to import %s [artifactId:%d]. Error message: %s\n", ProductMilestoneReleaseManager.orNull(artifact, Artifact::getIdentifier), artifactId, e.getErrorMessage()));
    }

    private static <T, R> R orNull(T value, Function<T, R> f) {
        return value == null ? null : (R)f.apply(value);
    }
}

