/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.pnc.causewayclient.CausewayClient;
import org.jboss.pnc.causewayclient.remotespi.Build;
import org.jboss.pnc.causewayclient.remotespi.BuildImportRequest;
import org.jboss.pnc.causewayclient.remotespi.BuildRoot;
import org.jboss.pnc.causewayclient.remotespi.BuiltArtifact;
import org.jboss.pnc.causewayclient.remotespi.CallbackTarget;
import org.jboss.pnc.causewayclient.remotespi.Dependency;
import org.jboss.pnc.causewayclient.remotespi.Logfile;
import org.jboss.pnc.causewayclient.remotespi.MavenBuild;
import org.jboss.pnc.causewayclient.remotespi.MavenBuiltArtifact;
import org.jboss.pnc.common.maven.Gav;
import org.jboss.pnc.managers.InProgress;
import org.jboss.pnc.managers.Result;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildRecordPushResult;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.rest.restmodel.BuildRecordPushResultRest;
import org.jboss.pnc.spi.coordinator.ProcessException;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordPushResultRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class BuildResultPushManager {
    private static final String EXECUTION_ROOT_NAME_PARAM = "EXECUTION_ROOT_NAME";
    private static final String PNC_BUILD_RECORD_PATH = "/pnc-rest/rest/build-records/%d";
    private static final String PNC_BUILD_LOG_PATH = "/pnc-rest/rest/build-records/%d/log";
    private static final String PNC_REPOUR_LOG_PATH = "/pnc-rest/rest/build-records/%d/repour-log";
    private BuildConfigurationRepository buildConfigurationRepository;
    private BuildRecordRepository buildRecordRepository;
    private BuildRecordPushResultRepository buildRecordPushResultRepository;
    private ArtifactRepository artifactRepository;
    private InProgress inProgress;
    private CausewayClient causewayClient;
    private Event<BuildRecordPushResultRest> buildRecordPushResultRestEvent;
    private Logger logger = LoggerFactory.getLogger(BuildResultPushManager.class);

    @Deprecated
    public BuildResultPushManager() {
    }

    @Inject
    public BuildResultPushManager(BuildConfigurationRepository buildConfigurationRepository, BuildRecordRepository buildRecordRepository, BuildRecordPushResultRepository buildRecordPushResultRepository, InProgress inProgress, Event<BuildRecordPushResultRest> buildRecordPushResultRestEvent, ArtifactRepository artifactRepository, CausewayClient causewayClient) {
        this.buildConfigurationRepository = buildConfigurationRepository;
        this.buildRecordRepository = buildRecordRepository;
        this.buildRecordPushResultRepository = buildRecordPushResultRepository;
        this.inProgress = inProgress;
        this.buildRecordPushResultRestEvent = buildRecordPushResultRestEvent;
        this.artifactRepository = artifactRepository;
        this.causewayClient = causewayClient;
    }

    public Set<Result> push(Set<Integer> buildRecordIds, String authToken, String callBackUrlTemplate, String tagPrefix, boolean reimport) {
        HashSet<Result> result = new HashSet<Result>();
        for (Integer buildRecordId : buildRecordIds) {
            BuildRecord buildRecord = (BuildRecord)this.buildRecordRepository.queryById((Serializable)buildRecordId);
            Integer pushBuildRecordId = null;
            if (BuildStatus.NO_REBUILD_REQUIRED.equals((Object)buildRecord.getStatus())) {
                IdRev idRev = buildRecord.getBuildConfigurationAuditedIdRev();
                if ((buildRecord = this.buildRecordRepository.getLatestSuccessfulBuildRecord(idRev, buildRecord.isTemporaryBuild())) != null) {
                    pushBuildRecordId = buildRecord.getId();
                } else {
                    this.logger.warn("Trying to push a BuildRecord.id: {} with status NO_REBUILD_REQUIRED and there is no successful result for the configuration.idRev: {}.", (Object)buildRecordId, (Object)idRev);
                }
            } else {
                pushBuildRecordId = buildRecordId;
            }
            if (pushBuildRecordId == null) continue;
            Result pushResult = this.pushToCauseway(authToken, pushBuildRecordId, String.format(callBackUrlTemplate, buildRecordId), tagPrefix, reimport);
            result.add(pushResult);
        }
        return result;
    }

    private Result pushToCauseway(String authToken, Integer buildRecordId, String callBackUrl, String tagPrefix, boolean reimport) {
        this.logger.info("Pushing to causeway BR.id: {}", (Object)buildRecordId);
        boolean successfullyPushed = false;
        String message = "Failed to push to Causeway.";
        if (!this.inProgress.add(buildRecordId, tagPrefix)) {
            this.logger.warn("Push for BR.id {} already running.", (Object)buildRecordId);
            return new Result(buildRecordId.toString(), Result.Status.REJECTED, "A push for this buildRecord is already running.");
        }
        try {
            BuildRecord buildRecord = this.buildRecordRepository.findByIdFetchProperties(buildRecordId);
            if (buildRecord == null) {
                this.logger.warn("Did not find build record by id: " + buildRecordId);
                message = "Did not find build record by given id.";
            } else if (!buildRecord.getStatus().completedSuccessfully()) {
                this.logger.warn("Not pushing record id: " + buildRecordId + " because it is a failed build.");
                message = "Cannot push failed build.";
            } else if (this.hasBadArtifactQuality(buildRecord.getBuiltArtifacts())) {
                this.logger.warn("Not pushing record id: " + buildRecordId + " because it contains artifacts of insufficient quality: BLACKLISTED/DELETED.");
                message = "Build contains artifacts of insufficient quality: BLACKLISTED/DELETED.";
            } else {
                BuildImportRequest buildImportRequest = this.createCausewayPushRequest(buildRecord, tagPrefix, callBackUrl, authToken, reimport);
                successfullyPushed = this.causewayClient.importBuild(buildImportRequest, authToken);
            }
        }
        catch (RuntimeException ex) {
            this.logger.error("Failed to push to Causeway.", (Throwable)ex);
            message = "Failed to push to Causeway: " + ex.getMessage();
        }
        if (!successfullyPushed) {
            this.inProgress.remove(buildRecordId);
            return new Result(buildRecordId.toString(), Result.Status.REJECTED, message);
        }
        return new Result(buildRecordId.toString(), Result.Status.ACCEPTED);
    }

    private BuildImportRequest createCausewayPushRequest(BuildRecord buildRecord, String tagPrefix, String callBackUrl, String authToken, boolean reimport) {
        BuildEnvironment buildEnvironment = buildRecord.getBuildConfigurationAudited().getBuildEnvironment();
        this.logger.debug("BuildRecord: {}", (Object)buildRecord.getId());
        this.logger.debug("BuildEnvironment: {}", (Object)buildEnvironment);
        BuildRoot buildRoot = new BuildRoot("DOCKER_IMAGE", "x86_64", "rhel", "x86_64", buildEnvironment.getAttributes());
        List builtArtifactEntities = this.artifactRepository.queryWithPredicates(new Predicate[]{ArtifactPredicates.withBuildRecordId((Integer)buildRecord.getId())});
        List dependencyEntities = this.artifactRepository.queryWithPredicates(new Predicate[]{ArtifactPredicates.withDependantBuildRecordId((Integer)buildRecord.getId())});
        this.logger.debug("Preparing BuildImportRequest containing {} built artifacts and {} dependencies.", (Object)builtArtifactEntities.size(), (Object)dependencyEntities.size());
        Set<Dependency> dependencies = this.collectDependencies(dependencyEntities);
        Set<BuiltArtifact> builtArtifacts = this.collectBuiltArtifacts(builtArtifactEntities);
        CallbackTarget callbackTarget = CallbackTarget.callbackPost((String)callBackUrl, (String)authToken);
        String executionRootName = null;
        BuildConfiguration bc = (BuildConfiguration)this.buildConfigurationRepository.queryById((Serializable)buildRecord.getBuildConfigurationId());
        Map genericParameters = bc.getGenericParameters();
        if (genericParameters.containsKey(EXECUTION_ROOT_NAME_PARAM)) {
            executionRootName = (String)genericParameters.get(EXECUTION_ROOT_NAME_PARAM);
        }
        if (executionRootName == null) {
            executionRootName = buildRecord.getExecutionRootName();
        }
        Gav rootGav = this.buildRootToGAV(executionRootName, buildRecord.getExecutionRootVersion());
        HashSet<Logfile> logs = new HashSet<Logfile>();
        this.addLogs(buildRecord, logs);
        MavenBuild build = new MavenBuild(rootGav.getGroupId(), rootGav.getArtifactId(), rootGav.getVersion(), executionRootName, buildRecord.getExecutionRootVersion(), "PNC", buildRecord.getId().intValue(), String.format(PNC_BUILD_RECORD_PATH, buildRecord.getId()), buildRecord.getStartTime(), buildRecord.getEndTime(), buildRecord.getScmRepoURL(), buildRecord.getScmRevision(), buildRecord.getScmTag(), buildRoot, logs, dependencies, builtArtifacts, tagPrefix);
        return new BuildImportRequest(callbackTarget, (Build)build, reimport);
    }

    private void addLogs(BuildRecord buildRecord, Set<Logfile> logs) {
        if (buildRecord.getBuildLogSize() != null && buildRecord.getBuildLogSize() > 0) {
            logs.add(new Logfile("build.log", this.getBuildLogPath(buildRecord.getId()), buildRecord.getBuildLogSize().intValue(), buildRecord.getBuildLogMd5()));
        } else {
            this.logger.warn("Missing build log for BR.id: {}.", (Object)buildRecord.getId());
        }
        if (buildRecord.getRepourLogSize() != null && buildRecord.getRepourLogSize() > 0) {
            logs.add(new Logfile("repour.log", this.getRepourLogPath(buildRecord.getId()), buildRecord.getRepourLogSize().intValue(), buildRecord.getRepourLogMd5()));
        } else {
            this.logger.warn("Missing repour log for BR.id: {}.", (Object)buildRecord.getId());
        }
    }

    private String getRepourLogPath(Integer id) {
        return String.format(PNC_REPOUR_LOG_PATH, id);
    }

    private String getBuildLogPath(Integer id) {
        return String.format(PNC_BUILD_LOG_PATH, id);
    }

    private Gav buildRootToGAV(String executionRootName, String executionRootVersion) {
        if (executionRootName == null) {
            throw new IllegalArgumentException("ExecutionRootName must be defined.");
        }
        String[] splittedName = executionRootName.split(":");
        if (splittedName.length != 2) {
            throw new IllegalArgumentException("Execution root '" + executionRootName + "' doesn't seem to be maven G:A.");
        }
        return new Gav(splittedName[0], splittedName[1], executionRootVersion);
    }

    private Set<BuiltArtifact> collectBuiltArtifacts(Collection<Artifact> builtArtifacts) {
        return builtArtifacts.stream().map(artifact -> {
            Gav gav = Gav.parse((String)artifact.getIdentifier());
            return new MavenBuiltArtifact(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), artifact.getId().intValue(), artifact.getFilename(), artifact.getTargetRepository().getRepositoryType().toString(), artifact.getMd5(), artifact.getDeployPath(), artifact.getTargetRepository().getRepositoryPath(), artifact.getSize().intValue());
        }).collect(Collectors.toSet());
    }

    private Set<Dependency> collectDependencies(Collection<Artifact> dependencies) {
        return dependencies.stream().map(artifact -> new Dependency(artifact.getFilename(), artifact.getMd5(), artifact.getSize().longValue())).collect(Collectors.toSet());
    }

    private boolean hasBadArtifactQuality(Collection<Artifact> builtArtifacts) {
        EnumSet<Artifact.Quality> badQuality = EnumSet.of(Artifact.Quality.DELETED, Artifact.Quality.BLACKLISTED);
        return builtArtifacts.stream().map(Artifact::getArtifactQuality).anyMatch(badQuality::contains);
    }

    public Integer complete(Integer buildRecordId, BuildRecordPushResult buildRecordPushResult) throws ProcessException {
        String completedTag = this.inProgress.remove(buildRecordId);
        if (completedTag == null) {
            throw new ProcessException("Did not find the referenced element.");
        }
        buildRecordPushResult.setTagPrefix(completedTag);
        BuildRecordPushResult saved = (BuildRecordPushResult)this.buildRecordPushResultRepository.save((GenericEntity)buildRecordPushResult);
        this.buildRecordPushResultRestEvent.fire((Object)new BuildRecordPushResultRest(saved));
        return saved.getId();
    }

    public boolean cancelInProgressPush(Integer buildRecordId) {
        BuildRecordPushResultRest buildRecordPushResultRest = BuildRecordPushResultRest.builder().status(BuildRecordPushResult.Status.CANCELED).buildRecordId(buildRecordId).log("Canceled.").build();
        boolean canceled = this.inProgress.remove(buildRecordId) != null;
        this.buildRecordPushResultRestEvent.fire((Object)buildRecordPushResultRest);
        return canceled;
    }

    public Set<Integer> getInProgress() {
        return this.inProgress.getAllIds();
    }
}

