/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.managers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Result {
    private final String id;
    private final Status status;
    private final String message;

    public Result(String id, Status status) {
        this.id = id;
        this.status = status;
        this.message = "";
    }

    @JsonCreator
    public Result(@JsonProperty(value="id") String id, @JsonProperty(value="status") Status status, @JsonProperty(value="message") String message) {
        this.id = id;
        this.status = status;
        this.message = message;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.status.isSuccess();
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum Status {
        ACCEPTED(true),
        SUCCESS(true),
        REJECTED(false),
        FAILED(false),
        SYSTEM_ERROR(false);

        private boolean success;

        private Status(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

