/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.requests.DeliverablesAnalysisRequest;
import org.jboss.pnc.dto.requests.validation.VersionValidationRequest;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.ValidationResponse;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.parameters.ProductMilestoneCloseParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Product Milestones")
@Path(value="/product-milestones")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ProductMilestoneEndpoint {
    public static final String PM_ID = "ID of the product milestone";
    public static final String CREATE_NEW_DESC = "Creates a new product milestone.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific product milestone.";
    public static final String UPDATE_DESC = "Updates an existing product milestone.";
    public static final String PATCH_SPECIFIC_DESC = "Patch an existing product milestone.";
    public static final String GET_BUILDS_DESC = "Gets builds performed during a product milestone cycle.";
    public static final String CLOSE_MILESTONE_DESC = "Close a product milestone.";
    public static final String CLOSE_MILESTONE_CANCEL_DESC = "Cancel product milestone close process.";
    public static final String GET_CLOSE_RESULTS = "Get milestone releases.";
    public static final String VALIDATE_VERSION = "Validate product milestone version.";
    public static final String DELIVERABLES_ANALYSIS_DESC = "Send a request to start analysis of deliverables. This endpoint creates an asynchronous task.";

    @Operation(summary="Creates a new product milestone.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public ProductMilestone createNew(@NotNull ProductMilestone var1);

    @Operation(summary="Gets a specific product milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductMilestone getSpecific(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing product milestone.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @NotNull ProductMilestone var2);

    @Operation(summary="Patch an existing product milestone.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ProductMilestone.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public ProductMilestone patchSpecific(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @NotNull ProductMilestone var2);

    @Operation(summary="Gets builds performed during a product milestone cycle.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    public Page<Build> getBuilds(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);

    @Operation(summary="Close a product milestone.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/close")
    public ProductMilestoneCloseResult closeMilestone(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Cancel product milestone close process.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/close")
    public void cancelMilestoneClose(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1);

    @Operation(summary="Get milestone releases.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.ProductMilestoneCloseResultPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/close-results")
    public Page<ProductMilestoneCloseResult> getCloseResults(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam ProductMilestoneCloseParameters var3);

    @Operation(summary="Validate product milestone version.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=ValidationResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/validate-version")
    public ValidationResponse validateVersion(@Valid VersionValidationRequest var1);

    @Operation(summary="Send a request to start analysis of deliverables. This endpoint creates an asynchronous task.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/analyze-deliverables")
    public void analyzeDeliverables(@Parameter(description="ID of the product milestone") @PathParam(value="id") String var1, @Valid DeliverablesAnalysisRequest var2);
}

