/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.parameters;

import io.swagger.v3.oas.annotations.Parameter;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import org.jboss.pnc.enums.RebuildMode;

public class BuildParameters {
    @Parameter(description="Is it a temporary build or a standard build?")
    @QueryParam(value="temporaryBuild")
    @DefaultValue(value="false")
    boolean temporaryBuild;
    @Parameter(description="What should varant rebuild?")
    @QueryParam(value="rebuildMode")
    @DefaultValue(value="IMPLICIT_DEPENDENCY_CHECK")
    RebuildMode rebuildMode;
    @Parameter(description="Should we build also dependencies of this Build Config?")
    @QueryParam(value="buildDependencies")
    @DefaultValue(value="true")
    boolean buildDependencies;
    @Parameter(description="Should we keep the build container running, if the build fails?")
    @QueryParam(value="keepPodOnFailure")
    @DefaultValue(value="false")
    boolean keepPodOnFailure;
    @Parameter(description="This feature was disabled. Setting this value has no effect on the build.")
    @QueryParam(value="timestampAlignment")
    @DefaultValue(value="false")
    boolean timestampAlignment;

    public boolean isTemporaryBuild() {
        return this.temporaryBuild;
    }

    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public boolean isBuildDependencies() {
        return this.buildDependencies;
    }

    public boolean isKeepPodOnFailure() {
        return this.keepPodOnFailure;
    }

    public boolean isTimestampAlignment() {
        return this.timestampAlignment;
    }

    public void setTemporaryBuild(boolean temporaryBuild) {
        this.temporaryBuild = temporaryBuild;
    }

    public void setRebuildMode(RebuildMode rebuildMode) {
        this.rebuildMode = rebuildMode;
    }

    public void setBuildDependencies(boolean buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public void setKeepPodOnFailure(boolean keepPodOnFailure) {
        this.keepPodOnFailure = keepPodOnFailure;
    }

    public void setTimestampAlignment(boolean timestampAlignment) {
        this.timestampAlignment = timestampAlignment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildParameters)) {
            return false;
        }
        BuildParameters other = (BuildParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTemporaryBuild() != other.isTemporaryBuild()) {
            return false;
        }
        if (this.isBuildDependencies() != other.isBuildDependencies()) {
            return false;
        }
        if (this.isKeepPodOnFailure() != other.isKeepPodOnFailure()) {
            return false;
        }
        if (this.isTimestampAlignment() != other.isTimestampAlignment()) {
            return false;
        }
        RebuildMode this$rebuildMode = this.getRebuildMode();
        RebuildMode other$rebuildMode = other.getRebuildMode();
        return !(this$rebuildMode == null ? other$rebuildMode != null : !this$rebuildMode.equals(other$rebuildMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTemporaryBuild() ? 79 : 97);
        result = result * 59 + (this.isBuildDependencies() ? 79 : 97);
        result = result * 59 + (this.isKeepPodOnFailure() ? 79 : 97);
        result = result * 59 + (this.isTimestampAlignment() ? 79 : 97);
        RebuildMode $rebuildMode = this.getRebuildMode();
        result = result * 59 + ($rebuildMode == null ? 43 : $rebuildMode.hashCode());
        return result;
    }

    public String toString() {
        return "BuildParameters(temporaryBuild=" + this.isTemporaryBuild() + ", rebuildMode=" + this.getRebuildMode() + ", buildDependencies=" + this.isBuildDependencies() + ", keepPodOnFailure=" + this.isKeepPodOnFailure() + ", timestampAlignment=" + this.isTimestampAlignment() + ")";
    }
}

