/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.PageReader;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.requests.GroupBuildPushRequest;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.rest.api.endpoints.GroupBuildEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;

public class GroupBuildClient
extends ClientBase<GroupBuildEndpoint> {
    public GroupBuildClient(Configuration configuration) {
        super(configuration, GroupBuildEndpoint.class);
    }

    public RemoteCollection<GroupBuild> getAll(Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupBuildEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupBuildEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<GroupBuild> getAll() throws RemoteResourceException {
        try {
            return this.getAll(Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAll(Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public GroupBuild getSpecific(String id) throws RemoteResourceException {
        try {
            return ((GroupBuildEndpoint)this.getEndpoint()).getSpecific(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((GroupBuildEndpoint)this.getEndpoint()).getSpecific(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void delete(String id, String callback) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupBuildEndpoint)this.getEndpoint()).delete(id, callback);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupBuildEndpoint)this.getEndpoint()).delete(id, callback);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupBuildEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, buildsFilter);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupBuildEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, buildsFilter);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters buildsFilter) throws RemoteResourceException {
        try {
            return this.getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getBuilds(id, buildsFilter, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void brewPush(String id, GroupBuildPushRequest buildConfigSetRecordPushRequest) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupBuildEndpoint)this.getEndpoint()).brewPush(id, buildConfigSetRecordPushRequest);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupBuildEndpoint)this.getEndpoint()).brewPush(id, buildConfigSetRecordPushRequest);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void cancel(String id) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupBuildEndpoint)this.getEndpoint()).cancel(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupBuildEndpoint)this.getEndpoint()).cancel(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public Graph<Build> getDependencyGraph(String id) throws RemoteResourceException {
        try {
            return ((GroupBuildEndpoint)this.getEndpoint()).getDependencyGraph(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((GroupBuildEndpoint)this.getEndpoint()).getDependencyGraph(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

