/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.PageReader;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.requests.GroupBuildRequest;
import org.jboss.pnc.rest.api.endpoints.GroupConfigurationEndpoint;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.GroupBuildParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;

public class GroupConfigurationClient
extends ClientBase<GroupConfigurationEndpoint> {
    public GroupConfigurationClient(Configuration configuration) {
        super(configuration, GroupConfigurationEndpoint.class);
    }

    public RemoteCollection<GroupConfiguration> getAll(Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupConfigurationEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupConfigurationEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<GroupConfiguration> getAll() throws RemoteResourceException {
        try {
            return this.getAll(Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAll(Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public GroupConfiguration createNew(GroupConfiguration groupConfig) throws RemoteResourceException {
        try {
            return ((GroupConfigurationEndpoint)this.getEndpoint()).createNew(groupConfig);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((GroupConfigurationEndpoint)this.getEndpoint()).createNew(groupConfig);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public GroupConfiguration getSpecific(String id) throws RemoteResourceException {
        try {
            return ((GroupConfigurationEndpoint)this.getEndpoint()).getSpecific(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((GroupConfigurationEndpoint)this.getEndpoint()).getSpecific(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void update(String id, GroupConfiguration groupConfig) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupConfigurationEndpoint)this.getEndpoint()).update(id, groupConfig);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupConfigurationEndpoint)this.getEndpoint()).update(id, groupConfig);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public GroupBuild trigger(String id, GroupBuildParameters buildParams, GroupBuildRequest request) throws RemoteResourceException {
        try {
            return ((GroupConfigurationEndpoint)this.getEndpoint()).trigger(id, buildParams, request);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((GroupConfigurationEndpoint)this.getEndpoint()).trigger(id, buildParams, request);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<BuildConfiguration> getBuildConfigs(String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupConfigurationEndpoint)this.getEndpoint()).getBuildConfigs(id, (PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupConfigurationEndpoint)this.getEndpoint()).getBuildConfigs(id, (PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<BuildConfiguration> getBuildConfigs(String id) throws RemoteResourceException {
        try {
            return this.getBuildConfigs(id, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getBuildConfigs(id, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void addBuildConfig(String id, BuildConfigurationRef buildConfig) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupConfigurationEndpoint)this.getEndpoint()).addBuildConfig(id, buildConfig);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupConfigurationEndpoint)this.getEndpoint()).addBuildConfig(id, buildConfig);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void removeBuildConfig(String id, String configId) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((GroupConfigurationEndpoint)this.getEndpoint()).removeBuildConfig(id, configId);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((GroupConfigurationEndpoint)this.getEndpoint()).removeBuildConfig(id, configId);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters filterParams, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupConfigurationEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, filterParams);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupConfigurationEndpoint)this.getEndpoint()).getBuilds(id, (PageParameters)pageParameters, filterParams);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<Build> getBuilds(String id, BuildsFilterParameters filterParams) throws RemoteResourceException {
        try {
            return this.getBuilds(id, filterParams, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getBuilds(id, filterParams, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<GroupBuild> getAllGroupBuilds(String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((GroupConfigurationEndpoint)this.getEndpoint()).getAllGroupBuilds(id, (PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((GroupConfigurationEndpoint)this.getEndpoint()).getAllGroupBuilds(id, (PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<GroupBuild> getAllGroupBuilds(String id) throws RemoteResourceException {
        try {
            return this.getAllGroupBuilds(id, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAllGroupBuilds(id, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

