/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.requests.CreateAndSyncSCMRequest;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="SCM Repositories")
@Path(value="/scm-repositories")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface SCMRepositoryEndpoint {
    public static final String SCM_ID = "ID of the SCM repository";
    public static final String MATCH_URL = "Url to search for";
    public static final String SEARCH_URL = "Url part to search for";
    public static final String GET_ALL = "Gets all SCM repositories.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific SCM repository.";
    public static final String UPDATE_DESC = "Updates an existing SCM repository.";
    public static final String PATCH_SPECIFIC = "Patch an existing SCM repository.";
    public static final String CREATE_NEW_DESC = "Creates a new SCM repository.";
    public static final String CREATE_NEW_DESC2 = "If the given URL is external, it does create the repository in the scm server.";
    public static final String GET_BUILD_CONFIGS = "Gets all build configs associated with a specific SCM repository.";

    @Operation(summary="Gets all SCM repositories.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.SCMRepositoryPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<SCMRepository> getAll(@Valid @BeanParam PageParameters var1, @Parameter(description="Url to search for") @QueryParam(value="url") String var2, @Parameter(description="Url part to search for") @QueryParam(value="search-url") String var3);

    @Operation(summary="Gets a specific SCM repository.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SCMRepository.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public SCMRepository getSpecific(@Parameter(description="ID of the SCM repository") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing SCM repository.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@Parameter(description="ID of the SCM repository") @PathParam(value="id") String var1, @NotNull SCMRepository var2);

    @Operation(summary="Patch an existing SCM repository.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SCMRepository.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public SCMRepository patchSpecific(@Parameter(description="ID of the SCM repository") @PathParam(value="id") String var1, @NotNull SCMRepository var2);

    @Operation(summary="Creates a new SCM repository.", description="If the given URL is external, it does create the repository in the scm server.", responses={@ApiResponse(responseCode="202", description="SCM Repository is being created. The 'taskId' key has the id of the Maitai process instance creating the repository ('repository' key is null)", content={@Content(schema=@Schema(implementation=RepositoryCreationResponse.class))}), @ApiResponse(responseCode="201", description="SCM Repository was created. The 'repository' key is populated with the details of the SCM Repository ('taskId' key is null)", content={@Content(schema=@Schema(implementation=RepositoryCreationResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/create-and-sync")
    public RepositoryCreationResponse createNew(@NotNull CreateAndSyncSCMRequest var1);

    @Operation(summary="Gets all build configs associated with a specific SCM repository.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/build-configs")
    public Page<BuildConfiguration> getBuildConfigs(@Parameter(description="ID of the SCM repository") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);
}

