/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.api.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildConfigurationWithLatestBuild;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.requests.BuildConfigWithSCMRequest;
import org.jboss.pnc.dto.response.AlignmentParameters;
import org.jboss.pnc.dto.response.BuildConfigCreationResponse;
import org.jboss.pnc.dto.response.ErrorResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.Parameter;
import org.jboss.pnc.rest.annotation.RespondWithStatus;
import org.jboss.pnc.rest.api.parameters.BuildParameters;
import org.jboss.pnc.rest.api.parameters.BuildsFilterParameters;
import org.jboss.pnc.rest.api.parameters.PageParameters;
import org.jboss.pnc.rest.api.swagger.response.SwaggerPages;

@Tag(name="Build Configs")
@Path(value="/build-configs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface BuildConfigurationEndpoint {
    public static final String BC_ID = "ID of the build config";
    public static final String REV = "Revision number of the build config";
    public static final String B_TYPE = "Build type specified in build config (MVN, NPM or GRADLE)";
    public static final String GET_ALL_DESC = "Gets all build configs.";
    public static final String GET_ALL_WITH_LATEST_BUILD_DESC = "Gets all build configs with latest build info included.";
    public static final String CREATE_NEW_DESC = "Creates a new build config.";
    public static final String GET_SPECIFIC_DESC = "Gets a specific build config.";
    public static final String UPDATE_DESC = "Updates an existing build config.";
    public static final String PATCH_SPECIFIC_DESC = "Patch a specific build config.";
    public static final String TRIGGER_DESC = "Triggers a build of a specific build config.";
    public static final String GET_BUILDS_DESC = "Get all builds associated with this build config.";
    public static final String CLONE_DESC = "Clones an existing build config.";
    public static final String GET_GROUP_CONFIGS_DESC = "Gets group configs associated with the specified build config.";
    public static final String GET_DEPENDENCIES_DESC = "Get the direct dependencies of the specified build config.";
    public static final String GET_DEPENDANTS_DESC = "Get the direct dependants of the specified build config.";
    public static final String ADD_DEPENDENCY_DESC = "Adds a dependency to the specified build config.";
    public static final String DEPENDENCY_ADD_DESC = "Depenendency to be added to the build config. Only id is important.";
    public static final String REMOVE_DEPENDECY_DESC = "Removes a dependency from the specified build config.";
    public static final String DEPENDENCY_REMOVE_DESC = "Depenendency to be removed from the build config. Only id is important.";
    public static final String GET_REVISIONS_DESC = "Gets audited revisions of this build config.";
    public static final String CREATE_REVISION_DESC = "Creates new build config revision.";
    public static final String CREATE_REVISION_DESC2 = "This endpoint can be used for updating build config while returning the new revision.";
    public static final String GET_REVISION_DESC = "Get specific audited revision of this build config.";
    public static final String TRIGGER_REVISION_DESC = "Triggers a build of a build config in a specific revision.";
    public static final String RESTORE_REVISION_DESC = "Restores a build config to a specific audited revision";
    public static final String CREATE_WITH_SCM_DESC = "Starts a task of creating a new build config with a given SCM URL.";
    public static final String CREATE_WITH_SCM_DESC2 = "The given SCM URL is automatically analyzed and if it's an external URL the content of the SCM repository is cloned into an internal repository.";
    public static final String GET_SUPPORTED_PARAMS_DESC = "Provides list of supported parameters.";
    public static final String GET_SUPPORTED_PARAMS_DESC2 = "Provides list of parameters supported by core, there can be also other parameters not known by core.";
    public static final String GET_DEFAULT_ALIGNMENT_PARAMS_DESC = "Provides string of default alignment parameters.";
    public static final String GET_DEFAULT_ALIGNMENT_PARAMS_DESC2 = "Provides default parameters for build config according to a build type chosen by a user.";

    @Operation(summary="Gets all build configs.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    public Page<BuildConfiguration> getAll(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Gets all build configs with latest build info included.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigWithLatestPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/x-with-latest-build")
    public Page<BuildConfigurationWithLatestBuild> getAllWithLatestBuild(@Valid @BeanParam PageParameters var1);

    @Operation(summary="Creates a new build config.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=BuildConfiguration.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    public BuildConfiguration createNew(@NotNull BuildConfiguration var1);

    @Operation(summary="Gets a specific build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildConfiguration.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public BuildConfiguration getSpecific(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1);

    @Operation(summary="Updates an existing build config.", responses={@ApiResponse(responseCode="204", description="Entity successfully updated"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/{id}")
    public void update(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @NotNull BuildConfiguration var2);

    @Operation(summary="Patch a specific build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildConfiguration.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    public BuildConfiguration patchSpecific(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, BuildConfiguration var2);

    @Operation(summary="Triggers a build of a specific build config.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing", content={@Content(schema=@Schema(implementation=Build.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/build")
    public Build trigger(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @BeanParam BuildParameters var2);

    @Operation(summary="Get all builds associated with this build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/builds")
    public Page<Build> getBuilds(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2, @BeanParam BuildsFilterParameters var3);

    @Operation(summary="Clones an existing build config.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=BuildConfiguration.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    @Path(value="/{id}/clone")
    public BuildConfiguration clone(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1);

    @Operation(summary="Gets group configs associated with the specified build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.GroupConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/group-configs")
    public Page<GroupConfiguration> getGroupConfigs(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Get the direct dependencies of the specified build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/dependencies")
    public Page<BuildConfiguration> getDependencies(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Get the direct dependants of the specified build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/dependants")
    public Page<BuildConfiguration> getDependants(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Adds a dependency to the specified build config.", responses={@ApiResponse(responseCode="204", description="Success but no content provided"), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/dependencies")
    public void addDependency(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @io.swagger.v3.oas.annotations.Parameter(description="Depenendency to be added to the build config. Only id is important.") BuildConfigurationRef var2);

    @Operation(summary="Removes a dependency from the specified build config.", responses={@ApiResponse(responseCode="204", description="Success but no content provided"), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @Path(value="/{id}/dependencies/{depId}")
    public void removeDependency(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @io.swagger.v3.oas.annotations.Parameter(description="Depenendency to be removed from the build config. Only id is important.") @PathParam(value="depId") String var2);

    @Operation(summary="Gets audited revisions of this build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=SwaggerPages.BuildConfigRevisionPage.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/revisions")
    public Page<BuildConfigurationRevision> getRevisions(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @Valid @BeanParam PageParameters var2);

    @Operation(summary="Creates new build config revision.", description="This endpoint can be used for updating build config while returning the new revision.", responses={@ApiResponse(responseCode="201", description="Entity successfully created", content={@Content(schema=@Schema(implementation=BuildConfigurationRevision.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.CREATED)
    @Path(value="/{id}/revisions")
    public BuildConfigurationRevision createRevision(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, BuildConfiguration var2);

    @Operation(summary="Get specific audited revision of this build config.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildConfigurationRevision.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/{id}/revisions/{rev}")
    public BuildConfigurationRevision getRevision(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @io.swagger.v3.oas.annotations.Parameter(description="Revision number of the build config") @PathParam(value="rev") int var2);

    @Operation(summary="Triggers a build of a build config in a specific revision.", responses={@ApiResponse(responseCode="202", description="Request was accepted for processing", content={@Content(schema=@Schema(implementation=Build.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @RespondWithStatus(value=Response.Status.ACCEPTED)
    @Path(value="/{id}/revisions/{rev}/build")
    public Build triggerRevision(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @io.swagger.v3.oas.annotations.Parameter(description="Revision number of the build config") @PathParam(value="rev") int var2, @BeanParam BuildParameters var3);

    @Operation(summary="Restores a build config to a specific audited revision", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=BuildConfiguration.class))}), @ApiResponse(responseCode="404", description="Can not find specified result"), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/{id}/revisions/{rev}/restore")
    public BuildConfiguration restoreRevision(@io.swagger.v3.oas.annotations.Parameter(description="ID of the build config") @PathParam(value="id") String var1, @io.swagger.v3.oas.annotations.Parameter(description="Revision number of the build config") @PathParam(value="rev") int var2);

    @Operation(summary="Starts a task of creating a new build config with a given SCM URL.", description="The given SCM URL is automatically analyzed and if it's an external URL the content of the SCM repository is cloned into an internal repository.", responses={@ApiResponse(responseCode="202", description="Build Config is being created. The 'taskId' key has the id of the Maitai process instance creating the repository ('buildConfig' key is null)", content={@Content(schema=@Schema(implementation=BuildConfigCreationResponse.class))}), @ApiResponse(responseCode="201", description="Build Config was created. The 'buildConfig' key is populated with the details of the Build Config ('taskId' key is null)", content={@Content(schema=@Schema(implementation=BuildConfigCreationResponse.class))}), @ApiResponse(responseCode="409", description="Conflict while saving an entity", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input parameters or validation error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Server error", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/create-with-scm")
    public BuildConfigCreationResponse createWithSCM(BuildConfigWithSCMRequest var1);

    @Operation(summary="Provides list of supported parameters.", description="Provides list of parameters supported by core, there can be also other parameters not known by core.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Parameter.class)))})})
    @GET
    @Path(value="/supported-parameters")
    public Set<Parameter> getSupportedParameters();

    @Operation(summary="Provides string of default alignment parameters.", description="Provides default parameters for build config according to a build type chosen by a user.", responses={@ApiResponse(responseCode="200", description="Success with results", content={@Content(schema=@Schema(implementation=AlignmentParameters.class))})})
    @GET
    @Path(value="/default-alignment-parameters/{buildType}")
    public AlignmentParameters getBuildTypeDefaultAlignmentParameters(@io.swagger.v3.oas.annotations.Parameter(description="Build type specified in build config (MVN, NPM or GRADLE)") @PathParam(value="buildType") String var1);
}

