/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client;

import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.client.ClientBase;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.PageReader;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.client.RemoteResourceNotFoundException;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.requests.CreateAndSyncSCMRequest;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.rest.api.endpoints.SCMRepositoryEndpoint;
import org.jboss.pnc.rest.api.parameters.PageParameters;

public class SCMRepositoryClient
extends ClientBase<SCMRepositoryEndpoint> {
    public SCMRepositoryClient(Configuration configuration) {
        super(configuration, SCMRepositoryEndpoint.class);
    }

    public RemoteCollection<SCMRepository> getAll(String matchUrl, String searchUrl, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((SCMRepositoryEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters, matchUrl, searchUrl);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((SCMRepositoryEndpoint)this.getEndpoint()).getAll((PageParameters)pageParameters, matchUrl, searchUrl);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<SCMRepository> getAll(String matchUrl, String searchUrl) throws RemoteResourceException {
        try {
            return this.getAll(matchUrl, searchUrl, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getAll(matchUrl, searchUrl, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public SCMRepository getSpecific(String id) throws RemoteResourceException {
        try {
            return ((SCMRepositoryEndpoint)this.getEndpoint()).getSpecific(id);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((SCMRepositoryEndpoint)this.getEndpoint()).getSpecific(id);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public void update(String id, SCMRepository scmRepository) throws RemoteResourceException, RemoteResourceNotFoundException {
        try {
            ((SCMRepositoryEndpoint)this.getEndpoint()).update(id, scmRepository);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    ((SCMRepositoryEndpoint)this.getEndpoint()).update(id, scmRepository);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RepositoryCreationResponse createNew(CreateAndSyncSCMRequest request) throws RemoteResourceException {
        try {
            return ((SCMRepositoryEndpoint)this.getEndpoint()).createNew(request);
        }
        catch (NotFoundException e) {
            throw new RemoteResourceNotFoundException((ClientErrorException)e);
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return ((SCMRepositoryEndpoint)this.getEndpoint()).createNew(request);
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<BuildConfiguration> getBuildConfigs(String id, Optional<String> sort, Optional<String> query) throws RemoteResourceException {
        try {
            PageReader pageLoader = new PageReader(pageParameters -> {
                this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                return ((SCMRepositoryEndpoint)this.getEndpoint()).getBuildConfigs(id, (PageParameters)pageParameters);
            }, this.getRemoteCollectionConfig());
            return pageLoader.getCollection();
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    PageReader pageLoader = new PageReader(pageParameters -> {
                        this.setSortAndQuery((PageParameters)pageParameters, sort, query);
                        return ((SCMRepositoryEndpoint)this.getEndpoint()).getBuildConfigs(id, (PageParameters)pageParameters);
                    }, this.getRemoteCollectionConfig());
                    return pageLoader.getCollection();
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }

    public RemoteCollection<BuildConfiguration> getBuildConfigs(String id) throws RemoteResourceException {
        try {
            return this.getBuildConfigs(id, Optional.empty(), Optional.empty());
        }
        catch (NotAuthorizedException e) {
            if (this.configuration.getBearerTokenSupplier() != null) {
                try {
                    this.bearerAuthentication.setToken(this.configuration.getBearerTokenSupplier().get());
                    return this.getBuildConfigs(id, Optional.empty(), Optional.empty());
                }
                catch (WebApplicationException wae) {
                    throw new RemoteResourceException(this.readErrorResponse(wae), wae);
                }
            }
            throw new RemoteResourceException(this.readErrorResponse((WebApplicationException)((Object)e)), (WebApplicationException)((Object)e));
        }
        catch (WebApplicationException e) {
            throw new RemoteResourceException(this.readErrorResponse(e), e);
        }
    }
}

